/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.mixins;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import com.redlimerl.speedrunigt.timer.category.condition.StatCategoryCondition;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3469;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3442.class})
public abstract class ServerStatHandlerMixin
extends class_3469 {
    @Shadow
    @Final
    private MinecraftServer field_15308;
    private int updateTick = 0;

    @Inject(method={"setStat"}, at={@At(value="TAIL")})
    public void onUpdate(class_1657 player, class_3445<?> stat, int value, CallbackInfo ci) {
        InGameTimer timer = InGameTimer.getInstance();
        if (timer.getCategory().getConditionJson() != null) {
            JsonObject jsonObject = this.getStatJson();
            for (CategoryCondition.Condition condition : timer.getCustomCondition().map(CategoryCondition::getConditionList).orElse(Lists.newArrayList())) {
                if (!(condition instanceof StatCategoryCondition)) continue;
                timer.updateCondition((StatCategoryCondition)condition, jsonObject);
            }
            timer.checkConditions();
        }
        if (timer.getStatus() == TimerStatus.NONE || timer.getStatus() == TimerStatus.COMPLETED_LEGACY) {
            return;
        }
        if (timer.getCategory() == RunCategories.ALL_BLOCKS && RunCategories.ALL_BLOCKS.isCompleted(this.field_15308)) {
            InGameTimer.complete();
        }
        if (this.updateTick++ > 20) {
            InGameTimerUtils.updateStatsJson(timer);
            this.updateTick = 0;
        }
    }

    private JsonObject getStatJson() {
        HashMap map = Maps.newHashMap();
        for (Object2IntMap.Entry entry : this.field_15431.object2IntEntrySet()) {
            class_3445 stat = (class_3445)entry.getKey();
            map.computeIfAbsent(stat.method_14949(), statType -> new JsonObject()).addProperty(stat.method_14951().toString(), (Number)entry.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonObject.add(class_7923.field_41193.method_10221((Object)((class_3448)entry.getKey())).toString(), (JsonElement)entry.getValue());
        }
        return jsonObject;
    }
}

