/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.mixins.access.ServerStatHandlerAccessor;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.option.SpeedRunOptions;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerClientUtils;
import com.redlimerl.speedrunigt.timer.TimerAdvancementTracker;
import com.redlimerl.speedrunigt.timer.category.InvalidCategoryException;
import com.redlimerl.speedrunigt.timer.logs.TimerPauseLog;
import com.redlimerl.speedrunigt.timer.logs.TimerTimeline;
import com.redlimerl.speedrunigt.timer.running.RunPortalPos;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1267;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class InGameTimerUtils {
    public static boolean IS_CHANGING_DIMENSION = false;
    public static boolean IS_KILLED_ENDER_DRAGON = false;
    public static boolean IS_CAN_WAIT_WORLD_LOAD = false;
    public static final HashSet<Object> CHANGED_OPTIONS = Sets.newHashSet();
    public static JsonObject STATS_UPDATE = null;
    public static boolean RETIME_IS_WAITING_LOAD = false;
    public static boolean IS_SET_SEED = false;
    public static boolean CAN_DISCONNECT = false;
    public static long LATEST_TIMER_TIME = 0L;

    @Nullable
    public static File getTimerLogDir(String worldName, String pathName) {
        File file;
        Path path;
        if (SpeedRunIGT.IS_CLIENT_SIDE) {
            if (worldName == null || worldName.isEmpty()) {
                return null;
            }
            path = FabricLoader.getInstance().getGameDir().resolve("saves").resolve(worldName);
        } else {
            path = FabricLoader.getInstance().getGameDir().resolve("world");
        }
        File worldFolder = path.toFile();
        File file2 = file = pathName.isEmpty() ? path.resolve("speedrunigt").toFile() : path.resolve("speedrunigt").resolve(pathName).toFile();
        if (!worldFolder.exists() || !worldFolder.isDirectory()) {
            SpeedRunIGT.error("World directory doesn't exist, couldn't make timer dirs");
            return null;
        }
        if (!file.exists()) {
            SpeedRunIGT.debug(file.mkdirs() ? "Made timer dirs" : "Failed to make timer dirs");
        } else if (!file.isDirectory()) {
            return null;
        }
        return file;
    }

    public static boolean isWaitingFirstInput() {
        return SpeedRunOption.getOption(SpeedRunOptions.WAITING_FIRST_INPUT).isFirstInput(InGameTimer.getInstance());
    }

    public static String logListToString(List<?> arrayList, int completeCount) {
        if (arrayList.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (completeCount > 0) {
            stringBuilder.append("/* The timer/log is segmented. If you need previous logs, check the igt_freeze").append(InGameTimer.getLogSuffix(completeCount - 1)).append(" file.").append(" */\n");
        }
        for (Object o : arrayList) {
            stringBuilder.append(o.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    private static String makeLogText(int length, Object text) {
        String empty = IntStream.range(0, Math.max(0, length - text.toString().length())).mapToObj(i -> " ").collect(Collectors.joining());
        return String.valueOf(text) + empty;
    }

    public static String pauseLogListToString(List<TimerPauseLog> arrayList, boolean makeHeader, int completeCount) {
        if (arrayList.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (completeCount > 0) {
            stringBuilder.append("/* The timer/log is segmented. If you need previous logs, check the igt_timer").append(InGameTimer.getLogSuffix(completeCount - 1)).append(" file.").append(" */\n");
        }
        if (makeHeader) {
            stringBuilder.append(InGameTimerUtils.makeLogText(5, "No")).append(InGameTimerUtils.makeLogText(15, "IGT")).append(InGameTimerUtils.makeLogText(15, "Start RTA")).append(InGameTimerUtils.makeLogText(15, "End RTA")).append(InGameTimerUtils.makeLogText(11, "Length")).append(InGameTimerUtils.makeLogText(11, "Retime?")).append("Reason / Notice").append("\n");
        }
        for (TimerPauseLog pause : arrayList) {
            stringBuilder.append(InGameTimerUtils.makeLogText(5, pause.getPauseCount())).append(InGameTimerUtils.makeLogText(15, InGameTimerUtils.timeToStringFormat(pause.getIGT()))).append(InGameTimerUtils.makeLogText(15, InGameTimerUtils.timeToStringFormat(pause.getUnpauseRTA() - pause.getPauseLength()))).append(InGameTimerUtils.makeLogText(15, InGameTimerUtils.timeToStringFormat(pause.getUnpauseRTA()))).append(InGameTimerUtils.makeLogText(11, InGameTimerUtils.millisecondToStringFormat(pause.getPauseLength()))).append(InGameTimerUtils.makeLogText(11, pause.getRetimeData().getRetimeNeedAmount() == 0L ? "" : InGameTimerUtils.millisecondToStringFormat(pause.getRetimeData().getRetimeNeedAmount()))).append(String.format("Paused by %s, Unpause by %s%s", pause.getPauseReason(), pause.getUnpauseReason(), pause.getRetimeData().getNoticeInfo().isEmpty() ? "" : " / " + pause.getRetimeData().getNoticeInfo())).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String timeToStringFormat(long time) {
        int seconds = (int)(time / 1000L) % 60;
        int minutes = (int)(time / 1000L) / 60;
        if (minutes > 59) {
            int hours = minutes / 60;
            return String.format("%d:%02d:%02d.%03d", hours, minutes %= 60, seconds, time % 1000L);
        }
        return String.format("%02d:%02d.%03d", minutes, seconds, time % 1000L);
    }

    public static String millisecondToStringFormat(long time) {
        int seconds = (int)(time / 1000L);
        return String.format("%d.%03d", seconds, time % 1000L);
    }

    public static synchronized JsonObject convertTimelineJson(InGameTimer timer) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("mc_version", InGameTimerUtils.getMinecraftVersion());
        jsonObject.addProperty("speedrunigt_version", SpeedRunIGT.MOD_VERSION);
        jsonObject.addProperty("category", timer.getCategory().getID());
        jsonObject.addProperty("run_type", timer.getRunType().getContext());
        jsonObject.addProperty("is_completed", Boolean.valueOf(timer.isCompleted()));
        jsonObject.addProperty("is_coop", Boolean.valueOf(timer.isCoop()));
        jsonObject.addProperty("is_hardcore", Boolean.valueOf(timer.isHardcore()));
        jsonObject.addProperty("world_name", timer.worldName);
        jsonObject.addProperty("is_cheat_allowed", Boolean.valueOf(timer.isCheatAvailable()));
        jsonObject.addProperty("default_gamemode", (Number)timer.getDefaultGameMode());
        jsonObject.addProperty("date", (Number)System.currentTimeMillis());
        jsonObject.addProperty("retimed_igt", (Number)timer.getRetimedInGameTime());
        jsonObject.addProperty("final_igt", (Number)timer.getInGameTime(false));
        jsonObject.addProperty("stats_igt", (Number)timer.getCompleteStatIGT());
        jsonObject.addProperty("final_rta", (Number)timer.getRealTimeAttack());
        if (timer.lanOpenedTime == null) {
            jsonObject.add("open_lan", (JsonElement)JsonNull.INSTANCE);
        } else {
            jsonObject.addProperty("open_lan", (Number)timer.lanOpenedTime);
        }
        JsonArray timelineArr = new JsonArray();
        for (TimerTimeline timeline : timer.getTimelines()) {
            JsonObject timelineObj = new JsonObject();
            timelineObj.addProperty("name", timeline.getName());
            timelineObj.addProperty("igt", (Number)timeline.getIGT());
            timelineObj.addProperty("rta", (Number)timeline.getRTA());
            timelineArr.add((JsonElement)timelineObj);
        }
        jsonObject.add("timelines", (JsonElement)timelineArr);
        jsonObject.add("advancements", SpeedRunIGT.GSON.toJsonTree(InGameTimerUtils.sortMapByValue(timer.getAdvancementsTracker().getAdvancements())));
        jsonObject.add("stats", (JsonElement)InGameTimerUtils.getStatsJson(timer));
        return jsonObject;
    }

    public static LinkedHashMap<String, TimerAdvancementTracker.AdvancementTrack> sortMapByValue(Map<String, TimerAdvancementTracker.AdvancementTrack> map) {
        LinkedList<Map.Entry<String, TimerAdvancementTracker.AdvancementTrack>> entries = new LinkedList<Map.Entry<String, TimerAdvancementTracker.AdvancementTrack>>(map.entrySet());
        entries.sort(Comparator.comparingLong(value -> ((TimerAdvancementTracker.AdvancementTrack)value.getValue()).getRTA()));
        LinkedHashMap<String, TimerAdvancementTracker.AdvancementTrack> result = new LinkedHashMap<String, TimerAdvancementTracker.AdvancementTrack>();
        for (Map.Entry entry : entries) {
            result.put((String)entry.getKey(), (TimerAdvancementTracker.AdvancementTrack)entry.getValue());
        }
        return result;
    }

    public static JsonObject getStatsJson(InGameTimer timer) {
        return timer.isServerIntegrated && STATS_UPDATE != null ? STATS_UPDATE : new JsonObject();
    }

    public static void updateStatsJson(InGameTimer timer) {
        JsonObject jsonObject = new JsonObject();
        MinecraftServer server = InGameTimerUtils.getServer();
        if (timer.isServerIntegrated && server != null && server.method_3760() != null) {
            ArrayList serverPlayerEntities = Lists.newArrayList((Iterable)server.method_3760().method_14571());
            for (class_3222 serverPlayerEntity : serverPlayerEntities) {
                jsonObject.add(serverPlayerEntity.method_5845(), (JsonElement)SpeedRunIGT.GSON.fromJson(((ServerStatHandlerAccessor)serverPlayerEntity.method_14248()).invokeAsString(), JsonObject.class));
            }
        }
        STATS_UPDATE = jsonObject;
    }

    public static boolean isHardcoreWorld() {
        if (SpeedRunIGT.IS_CLIENT_SIDE) {
            return InGameTimerClientUtils.isHardcoreWorld();
        }
        return SpeedRunIGT.DEDICATED_SERVER.method_3754();
    }

    public static String getMinecraftVersion() {
        Optional mcContainer = FabricLoader.getInstance().getModContainer("minecraft");
        if (mcContainer.isPresent()) {
            ModContainer mc = (ModContainer)mcContainer.get();
            return mc.getMetadata().getVersion().getFriendlyString();
        }
        return "unknown";
    }

    public static boolean isLoadableBlind(class_5321<class_1937> worldKey, class_243 netherPos, class_243 overPos) {
        class_243 targetPos;
        CopyOnWriteArrayList<RunPortalPos> arrayList;
        InGameTimer timer = InGameTimer.getInstance();
        CopyOnWriteArrayList<RunPortalPos> copyOnWriteArrayList = worldKey == class_1937.field_25180 ? timer.lastNetherPortalPos : (arrayList = worldKey == class_1937.field_25179 ? timer.lastOverWorldPortalPos : null);
        Object object = worldKey == class_1937.field_25180 ? netherPos : (targetPos = worldKey == class_1937.field_25179 ? overPos : null);
        if (arrayList == null || targetPos == null) {
            return true;
        }
        for (RunPortalPos portalPos : arrayList) {
            if (!(portalPos.squaredDistanceTo(targetPos) < 16.0)) continue;
            return false;
        }
        timer.lastNetherPortalPos.add(new RunPortalPos(netherPos));
        timer.lastOverWorldPortalPos.add(new RunPortalPos(overPos));
        return true;
    }

    public static int isBlindTraveled(class_243 netherPos) {
        InGameTimer timer = InGameTimer.getInstance();
        for (int i = 0; i < timer.lastNetherPortalPos.size(); ++i) {
            if (!(timer.lastNetherPortalPos.get(i).squaredDistanceTo(netherPos) < 16.0)) continue;
            return i;
        }
        return -1;
    }

    public static int getPortalNumber(class_243 portalPos) {
        int index = InGameTimerUtils.isBlindTraveled(portalPos);
        return Math.max(InGameTimerUtils.hasHomeTraveled() ? index : index - 1, 0);
    }

    public static boolean hasHomeTraveled() {
        for (TimerTimeline timeline : InGameTimer.getInstance().getTimelines()) {
            if (!timeline.getName().equalsIgnoreCase("nether_travel_home")) continue;
            return true;
        }
        return false;
    }

    public static void setCategoryWarningScreen(@Nullable String conditionFileName, InvalidCategoryException exception) {
        if (SpeedRunIGT.IS_CLIENT_SIDE) {
            InGameTimerClientUtils.setCategoryWarningScreen(conditionFileName, exception);
        }
        SpeedRunIGT.error(exception.getDetails());
    }

    public static MinecraftServer getServer() {
        return SpeedRunIGT.IS_CLIENT_SIDE ? InGameTimerClientUtils.getClientServer() : SpeedRunIGT.DEDICATED_SERVER;
    }

    public static int getItemCountFromShulkerBox(class_1937 world, class_1799 itemStack, class_1792 targetItem) {
        int count = 0;
        if (!(itemStack.method_7909() instanceof class_1747) || !(((class_1747)itemStack.method_7909()).method_7711() instanceof class_2480)) {
            return 0;
        }
        Iterable stacks = ((class_9288)itemStack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_59714();
        for (class_1799 stack : stacks) {
            if (stack == null || stack.method_7909() != targetItem) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static int getCurrentWorldDefaultGameMode() {
        MinecraftServer server = InGameTimerUtils.getServer();
        if (server == null) {
            return class_1934.field_9215.method_8379();
        }
        return server.method_3790().method_8379();
    }

    public static boolean isCurrentWorldCheatAvailable() {
        MinecraftServer server = InGameTimerUtils.getServer();
        if (server == null) {
            return false;
        }
        return server.method_3760().method_14579();
    }

    public static class_1267 getCurrentDifficulty() {
        MinecraftServer server = InGameTimerUtils.getServer();
        if (server == null) {
            return class_1267.field_5805;
        }
        return server.method_27728().method_207();
    }
}

