/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.mixins.access.FontManagerAccessor;
import com.redlimerl.speedrunigt.mixins.access.MinecraftClientAccessor;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.option.SpeedRunOptions;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerClientUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerElement;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.running.RunType;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11719;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class TimerDrawer {
    public static final HashMap<String, Float> fontHeightMap = new HashMap();
    private final boolean translateZ;
    private final class_310 client = class_310.method_1551();
    private boolean needUpdate = false;
    private float igtXPos;
    private float igtYPos;
    private float igtScale;
    private Integer igtColor;
    private SpeedRunOptions.TimerDecoration igtDecoration;
    private SpeedRunOptions.TimerDisplayAlign igtDisplayAlign;
    private float rtaXPos;
    private float rtaYPos;
    private float rtaScale;
    private Integer rtaColor;
    private SpeedRunOptions.TimerDecoration rtaDecoration;
    private SpeedRunOptions.TimerDisplayAlign rtaDisplayAlign;
    private int igtPadding;
    private int rtaPadding;
    private float bgOpacity;
    private boolean simply;
    private boolean toggle;
    private boolean isLocked;
    private SpeedRunOptions.TimerDecimals timerDecimals;
    private class_2960 timerFont;

    public TimerDrawer(boolean translateZ) {
        this(translateZ, SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_POSITION_X).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_POSITION_Y).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_SCALE).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_COLOR), SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_DECO), SpeedRunOption.getOption(SpeedRunOptions.TIMER_IGT_DISPLAY_ALIGN), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_POSITION_X).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_POSITION_Y).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_SCALE).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_COLOR), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_DECO), SpeedRunOption.getOption(SpeedRunOptions.TIMER_RTA_DISPLAY_ALIGN), SpeedRunOption.getOption(SpeedRunOptions.IGT_BACKGROUND_PADDING), SpeedRunOption.getOption(SpeedRunOptions.RTA_BACKGROUND_PADDING), SpeedRunOption.getOption(SpeedRunOptions.BACKGROUND_OPACITY).floatValue(), SpeedRunOption.getOption(SpeedRunOptions.DISPLAY_TIME_ONLY), SpeedRunOption.getOption(SpeedRunOptions.TOGGLE_TIMER), SpeedRunOption.getOption(SpeedRunOptions.LOCK_TIMER_POSITION), SpeedRunOption.getOption(SpeedRunOptions.DISPLAY_DECIMALS), SpeedRunOption.getOption(SpeedRunOptions.TIMER_TEXT_FONT));
    }

    public TimerDrawer(boolean translateZ, float igtXPos, float igtYPos, float igtScale, Integer igtColor, SpeedRunOptions.TimerDecoration igtDecoration, SpeedRunOptions.TimerDisplayAlign igtDisplayAlign, float rtaXPos, float rtaYPos, float rtaScale, Integer rtaColor, SpeedRunOptions.TimerDecoration rtaDecoration, SpeedRunOptions.TimerDisplayAlign rtaDisplayAlign, int igtPadding, int rtaPadding, float bgOpacity, boolean simply, boolean toggle, boolean isLocked, SpeedRunOptions.TimerDecimals timerDecimals, class_2960 timerFont) {
        this.translateZ = translateZ;
        this.igtXPos = igtXPos;
        this.igtYPos = igtYPos;
        this.igtScale = igtScale;
        this.igtColor = igtColor;
        this.igtDecoration = igtDecoration;
        this.igtDisplayAlign = igtDisplayAlign;
        this.rtaXPos = rtaXPos;
        this.rtaYPos = rtaYPos;
        this.rtaScale = rtaScale;
        this.rtaColor = rtaColor;
        this.rtaDecoration = rtaDecoration;
        this.rtaDisplayAlign = rtaDisplayAlign;
        this.igtPadding = igtPadding;
        this.rtaPadding = rtaPadding;
        this.bgOpacity = bgOpacity;
        this.simply = simply;
        this.toggle = toggle;
        this.isLocked = isLocked;
        this.timerDecimals = timerDecimals;
        this.timerFont = timerFont;
    }

    public float getIGT_XPos() {
        return this.igtXPos;
    }

    public void setIGT_XPos(float igtXPos) {
        this.igtXPos = igtXPos;
    }

    public float getIGT_YPos() {
        return this.igtYPos;
    }

    public void setIGT_YPos(float igtYPos) {
        this.igtYPos = igtYPos;
    }

    public float getRTA_XPos() {
        return this.rtaXPos;
    }

    public void setRTA_XPos(float rtaXPos) {
        this.rtaXPos = rtaXPos;
    }

    public float getRTA_YPos() {
        return this.rtaYPos;
    }

    public void setRTA_YPos(float rtaYPos) {
        this.rtaYPos = rtaYPos;
    }

    public float getIGTScale() {
        return this.igtScale;
    }

    public float getRTAScale() {
        return this.rtaScale;
    }

    public boolean isSimplyTimer() {
        return this.simply;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public Integer getIGTColor() {
        return this.igtColor;
    }

    public Integer getRTAColor() {
        return this.rtaColor;
    }

    public void setIGTScale(float igtScale) {
        this.igtScale = igtScale;
    }

    public void setRTAScale(float rtaScale) {
        this.rtaScale = rtaScale;
    }

    public void setSimplyTimer(boolean simply) {
        this.simply = simply;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public void setIGTColor(Integer igtColor) {
        this.igtColor = igtColor;
    }

    public void setRTAColor(Integer rtaColor) {
        this.rtaColor = rtaColor;
    }

    public SpeedRunOptions.TimerDecoration getIGTDecoration() {
        return this.igtDecoration;
    }

    public void setIGTDecoration(SpeedRunOptions.TimerDecoration igtDecoration) {
        this.igtDecoration = igtDecoration;
    }

    public SpeedRunOptions.TimerDecoration getRTADecoration() {
        return this.rtaDecoration;
    }

    public void setRTADecoration(SpeedRunOptions.TimerDecoration rtaDecoration) {
        this.rtaDecoration = rtaDecoration;
    }

    public SpeedRunOptions.TimerDisplayAlign getRTADisplayAlign() {
        return this.rtaDisplayAlign;
    }

    public void setRTADisplayAlign(SpeedRunOptions.TimerDisplayAlign rtaDisplayAlign) {
        this.rtaDisplayAlign = rtaDisplayAlign;
    }

    public SpeedRunOptions.TimerDisplayAlign getIGTDisplayAlign() {
        return this.igtDisplayAlign;
    }

    public void setIGTDisplayAlign(SpeedRunOptions.TimerDisplayAlign igtDisplayAlign) {
        this.igtDisplayAlign = igtDisplayAlign;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public SpeedRunOptions.TimerDecimals getTimerDecimals() {
        return this.timerDecimals;
    }

    public void setTimerDecimals(SpeedRunOptions.TimerDecimals timerDecimals) {
        this.timerDecimals = timerDecimals;
    }

    public class_2960 getTimerFont() {
        return this.timerFont;
    }

    public void setTimerFont(class_2960 timerFont) {
        this.timerFont = timerFont;
    }

    public int getIGTPadding() {
        return this.igtPadding;
    }

    public void setIGTPadding(int igtPadding) {
        this.igtPadding = igtPadding;
    }

    public int getRTAPadding() {
        return this.rtaPadding;
    }

    public void setRTAPadding(int rtaPadding) {
        this.rtaPadding = rtaPadding;
    }

    public float getBGOpacity() {
        return this.bgOpacity;
    }

    public void setBGOpacity(float bgOpacity) {
        this.bgOpacity = bgOpacity;
    }

    public void update() {
        this.needUpdate = true;
    }

    public boolean isNeedUpdate() {
        boolean result = this.needUpdate;
        this.needUpdate = false;
        return result;
    }

    private String getTimeFormat(long time) {
        if ((InGameTimer.getInstance().isCompleted() || InGameTimer.getInstance().isPaused()) && this.translateZ) {
            return InGameTimerUtils.timeToStringFormat(time);
        }
        String millsString = String.format("%03d", time % 1000L).substring(0, this.timerDecimals.getNumber());
        int seconds = (int)(time / 1000L) % 60;
        int minutes = (int)(time / 1000L) / 60;
        if (minutes > 59) {
            int hours = minutes / 60;
            minutes %= 60;
            if (this.timerDecimals == SpeedRunOptions.TimerDecimals.NONE) {
                return String.format("%d:%02d:%02d", hours, minutes, seconds);
            }
            return String.format("%d:%02d:%02d.%s", hours, minutes, seconds, millsString);
        }
        if (this.timerDecimals == SpeedRunOptions.TimerDecimals.NONE) {
            return String.format("%02d:%02d", minutes, seconds);
        }
        return String.format("%02d:%02d.%s", minutes, seconds, millsString);
    }

    public class_5250 getIGTText() {
        InGameTimer timer = InGameTimer.getInstance();
        if (SpeedRunOption.getOption(SpeedRunOptions.TIMER_LEGACY_IGT_MODE).booleanValue() && timer.isServerIntegrated && InGameTimerUtils.getServer() != null && SpeedRunIGT.IS_CLIENT_SIDE) {
            Long inGameTime;
            Long l = inGameTime = timer.isCompleted() ? timer.getCompleteStatIGT() : InGameTimerClientUtils.getPlayerTime();
            if (inGameTime != null) {
                return class_2561.method_43470((String)((this.simply ? "" : "IGT: ") + this.getTimeFormat(inGameTime)));
            }
        }
        long igt = timer.isCompleted() && SpeedRunOption.getOption(SpeedRunOptions.AUTO_RETIME_FOR_GUIDELINE) != false && timer.getCategory() == RunCategories.ANY && timer.getRunType() == RunType.RANDOM_SEED && System.currentTimeMillis() / 3000L % 2L == 0L ? timer.getRetimedInGameTime() : timer.getInGameTime();
        return class_2561.method_43470((String)((this.simply ? "" : "IGT: ") + this.getTimeFormat(igt)));
    }

    public class_5250 getRTAText() {
        return class_2561.method_43470((String)((this.simply ? "" : "RTA: ") + this.getTimeFormat(InGameTimer.getInstance().getRealTimeAttack())));
    }

    public void draw(class_332 drawContext) {
        if (!this.toggle) {
            return;
        }
        class_5250 igtText = this.getIGTText();
        class_5250 rtaText = this.getRTAText();
        float fontHeight = 8.0f;
        if (!SpeedRunOption.getOption(SpeedRunOptions.CUSTOM_FONT_SAFE_MODE).booleanValue()) {
            FontManagerAccessor fontManager = (FontManagerAccessor)((MinecraftClientAccessor)this.client).getFontManager();
            if (this.getTimerFont() != class_310.field_1740 && fontManager.getFontStorages().containsKey(this.getTimerFont())) {
                rtaText.method_10862(rtaText.method_10866().method_27704((class_11719)new class_11719.class_11721(this.getTimerFont())));
                igtText.method_10862(igtText.method_10866().method_27704((class_11719)new class_11719.class_11721(this.getTimerFont())));
            }
        }
        TimerElement igtTimerElement = new TimerElement();
        TimerElement rtaTimerElement = new TimerElement();
        rtaTimerElement.init(this.rtaXPos, this.rtaYPos, this.rtaScale, rtaText, this.rtaColor, this.rtaDecoration, this.rtaDisplayAlign, fontHeight);
        igtTimerElement.init(this.igtXPos, this.igtYPos, this.igtScale, igtText, this.igtColor, this.igtDecoration, this.igtDisplayAlign, fontHeight);
        drawContext.method_51448().pushMatrix();
        if (this.bgOpacity > 0.01f) {
            Position rtaMin = new Position(rtaTimerElement.getPosition().getX() - this.rtaPadding, rtaTimerElement.getPosition().getY() - this.rtaPadding);
            Position rtaMax = new Position(rtaMin.getX() + rtaTimerElement.getScaledTextWidth() + (this.rtaPadding - 1 + this.rtaPadding), rtaMin.getY() + rtaTimerElement.getScaledTextHeight() + (this.rtaPadding - 1 + this.rtaPadding));
            Position igtMin = new Position(igtTimerElement.getPosition().getX() - this.igtPadding, igtTimerElement.getPosition().getY() - this.igtPadding);
            Position igtMax = new Position(igtMin.getX() + igtTimerElement.getScaledTextWidth() + (this.igtPadding - 1 + this.igtPadding), igtMin.getY() + igtTimerElement.getScaledTextHeight() + (this.igtPadding - 1 + this.igtPadding));
            int opacity = class_9848.method_61324((int)((int)(this.bgOpacity * 255.0f)), (int)0, (int)0, (int)0);
            if (rtaMin.getX() < igtMax.getX() && rtaMin.getY() < igtMax.getY() && igtMin.getX() < rtaMax.getX() && igtMin.getY() < rtaMax.getY()) {
                drawContext.method_25294(Math.min(rtaMin.getX(), igtMin.getX()), Math.min(rtaMin.getY(), igtMin.getY()), Math.max(rtaMax.getX(), igtMax.getX()), Math.max(rtaMax.getY(), igtMax.getY()), opacity);
            } else {
                if (this.rtaScale != 0.0f) {
                    drawContext.method_25294(rtaMin.getX(), rtaMin.getY(), rtaMax.getX(), rtaMax.getY(), opacity);
                }
                if (this.igtScale != 0.0f) {
                    drawContext.method_25294(igtMin.getX(), igtMin.getY(), igtMax.getX(), igtMax.getY(), opacity);
                }
            }
        }
        if (this.igtScale != 0.0f) {
            igtTimerElement.draw(drawContext, this.translateZ);
        }
        if (this.rtaScale != 0.0f) {
            rtaTimerElement.draw(drawContext, this.translateZ);
        }
        drawContext.method_51448().popMatrix();
    }

    public static class Position {
        private int x;
        private int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }

    public static enum PositionType {
        DEFAULT,
        WHILE_F3,
        WHILE_PAUSED;

    }
}

