/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer.category.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.redlimerl.speedrunigt.timer.category.InvalidCategoryException;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_7923;
import net.minecraft.class_9323;

public class ObtainItemCategoryCondition
extends CategoryCondition.Condition<List<class_1799>> {
    private final String itemID;
    private final Integer itemDamage;
    private final int itemAmount;
    private final class_2487 nbtTag;
    private final boolean strictMode;

    public ObtainItemCategoryCondition(JsonObject jsonObject) throws InvalidCategoryException {
        super(jsonObject);
        try {
            this.itemID = jsonObject.get("item_id").getAsString();
            this.itemAmount = jsonObject.has("item_amount") ? jsonObject.get("item_amount").getAsInt() : 1;
            this.itemDamage = jsonObject.has("item_damage") ? Integer.valueOf(jsonObject.get("item_damage").getAsInt()) : null;
            boolean bl = this.strictMode = !jsonObject.has("strict_mode") || jsonObject.get("strict_mode").getAsBoolean();
            if (jsonObject.has("item_tag")) {
                JsonElement jsonElement = jsonObject.get("item_tag");
                this.nbtTag = class_2522.method_67315((String)jsonElement.getAsString());
            } else {
                this.nbtTag = new class_2487();
            }
        }
        catch (Exception e) {
            throw new InvalidCategoryException(InvalidCategoryException.Reason.INVALID_JSON_DATA, "Failed to read condition \"" + this.getName() + "\"");
        }
    }

    @Override
    public boolean checkConditionComplete(List<class_1799> itemStacks) {
        int amount = 0;
        for (class_1799 itemStack : itemStacks) {
            class_9323 itemTag;
            if (itemStack == null || !Objects.equals(class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString(), this.itemID) || this.itemDamage != null && itemStack.method_7919() != this.itemDamage.intValue() || !this.nbtTag.method_33133() && (itemStack.method_57353() == null || !(itemTag = itemStack.method_57353()).equals((Object)this.nbtTag))) continue;
            amount += itemStack.method_7947();
        }
        return amount >= this.itemAmount;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }
}

