/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer.logs;

import java.io.Serializable;

public class TimerPauseLog
implements Serializable {
    private final String rp;
    private final String ru;
    private final long igt;
    private final long ct;
    private final long pt;
    private final int n;
    private final Retime r;

    public TimerPauseLog(String pauseReason, String unpauseReason, long currentIGT, long currentRTA, long pauseLength, int pauseCount, Retime retime) {
        this.rp = pauseReason;
        this.ru = unpauseReason;
        this.igt = currentIGT;
        this.ct = currentRTA;
        this.pt = pauseLength;
        this.n = pauseCount;
        this.r = retime;
    }

    public String getPauseReason() {
        return this.rp;
    }

    public String getUnpauseReason() {
        return this.ru;
    }

    public long getIGT() {
        return this.igt;
    }

    public long getUnpauseRTA() {
        return this.ct;
    }

    public long getPauseLength() {
        return this.pt;
    }

    public int getPauseCount() {
        return this.n;
    }

    public Retime getRetimeData() {
        return this.r;
    }

    public static class Retime
    implements Serializable {
        private final long i;
        private final String t;

        public Retime(long retimed, String notice) {
            this.i = retimed;
            this.t = notice;
        }

        public long getRetimeNeedAmount() {
            return this.i;
        }

        public String getNoticeInfo() {
            return this.t;
        }
    }
}

