/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer.packet.packets;

import com.google.common.collect.Lists;
import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import com.redlimerl.speedrunigt.timer.packet.TimerPacket;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class TimerCustomConditionPacket
extends TimerPacket<TimerCustomConditionPacket> {
    public static final class_8710.class_9154<TimerCustomConditionPacket> IDENTIFIER = TimerPacket.identifier("condition_custom");
    public static final class_9139<class_9129, TimerCustomConditionPacket> CODEC = TimerPacket.codecOf(TimerCustomConditionPacket::write, TimerCustomConditionPacket::new);
    private final String conditionName;

    TimerCustomConditionPacket(String conditionName) {
        super(IDENTIFIER);
        this.conditionName = conditionName;
    }

    public TimerCustomConditionPacket(CategoryCondition.Condition<?> condition) {
        this(condition.getName());
    }

    public TimerCustomConditionPacket(class_9129 buf) {
        this(buf.method_19772());
    }

    @Override
    protected void write(class_9129 buf) {
        buf.method_10814(this.conditionName);
    }

    @Override
    public void receiveClient2ServerPacket(MinecraftServer server) {
        if (!SpeedRunIGT.IS_CLIENT_SIDE) {
            this.updateTimerCondition();
        }
        this.sendPacketToPlayers(server);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void receiveServer2ClientPacket(class_310 client) {
        this.updateTimerCondition();
    }

    public void updateTimerCondition() {
        for (CategoryCondition.Condition condition : InGameTimer.getInstance().getCustomCondition().map(CategoryCondition::getConditionList).orElse(Lists.newArrayList())) {
            if (!Objects.equals(condition.getName(), this.conditionName)) continue;
            condition.setCompleted(true);
            InGameTimer.getInstance().tryInsertNewTimeline(condition.getName(), false);
            break;
        }
        InGameTimer.getInstance().checkConditions();
    }
}

