/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.mixins;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import com.redlimerl.speedrunigt.timer.category.condition.ObtainItemCategoryCondition;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1313;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
extends class_742 {
    @Shadow
    @Final
    protected class_310 field_3937;
    private Long latestPortalEnter = null;
    private int portalTick = 0;

    public ClientPlayerEntityMixin(class_638 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method={"move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V"}, at={@At(value="TAIL")})
    private void onMove(class_1313 movementType, class_243 vec3d, CallbackInfo ci) {
        InGameTimer timer = InGameTimer.getInstance();
        if (timer.getStatus() == TimerStatus.NONE || timer.getStatus() == TimerStatus.COMPLETED_LEGACY) {
            return;
        }
        if (timer.getStatus() == TimerStatus.IDLE && !InGameTimerUtils.IS_CHANGING_DIMENSION && (vec3d.field_1352 != 0.0 || vec3d.field_1350 != 0.0 || this.field_6282 || this.method_5715())) {
            timer.setPause(false, "moved player");
        }
        if (vec3d.field_1352 != 0.0 || vec3d.field_1350 != 0.0 || this.field_6282) {
            timer.updateFirstInput();
        }
        ArrayList playerItemList = Lists.newArrayList();
        playerItemList.addAll(this.method_31548().method_67533());
        for (Integer slotId : class_1661.field_56551.keySet()) {
            playerItemList.add(this.method_31548().method_5438(slotId.intValue()));
        }
        if (timer.getCategory().getConditionJson() != null) {
            for (CategoryCondition.Conditions conditions : timer.getCustomCondition().map(CategoryCondition::getConditions).orElse(Lists.newArrayList())) {
                ObtainItemCategoryCondition obtainItemCondition;
                int strict = 0;
                for (CategoryCondition.Condition<?> condition : conditions.getConditions()) {
                    if (!(condition instanceof ObtainItemCategoryCondition)) continue;
                    obtainItemCondition = (ObtainItemCategoryCondition)condition;
                    boolean canComplete = obtainItemCondition.checkConditionComplete(playerItemList);
                    if (obtainItemCondition.isStrictMode()) {
                        if (canComplete) continue;
                        ++strict;
                        continue;
                    }
                    timer.updateCondition(obtainItemCondition, playerItemList);
                }
                if (strict != 0) continue;
                for (CategoryCondition.Condition<?> condition : conditions.getConditions()) {
                    if (!(condition instanceof ObtainItemCategoryCondition)) continue;
                    obtainItemCondition = (ObtainItemCategoryCondition)condition;
                    timer.updateCondition(obtainItemCondition, playerItemList);
                }
            }
            timer.checkConditions();
        }
        if (timer.getCategory() == RunCategories.HIGH && this.method_23318() >= 420.0) {
            InGameTimer.complete();
            return;
        }
        if (timer.getCategory() == RunCategories.FULL_INV) {
            if (this.method_31548().method_67533().stream().filter(itemStack -> itemStack != null && itemStack != class_1799.field_8037 && itemStack.method_7909() != class_1802.field_8162).map(class_1799::method_7909).distinct().toArray().length == 36) {
                InGameTimer.complete();
            }
            return;
        }
        for (class_1799 itemStack2 : playerItemList) {
            int shells = 0;
            if (itemStack2 == null) continue;
            if (itemStack2.method_7909() == class_1802.field_8547) {
                timer.tryInsertNewTimeline("got_trident");
            }
            if (itemStack2.method_7909() == class_1802.field_8864) {
                shells += itemStack2.method_7947();
            }
            if (itemStack2.method_7909() instanceof class_1747 && ((class_1747)itemStack2.method_7909()).method_7711() instanceof class_2480) {
                shells += InGameTimerUtils.getItemCountFromShulkerBox(this.method_73183(), itemStack2, class_1802.field_8864);
            }
            if (shells > timer.getMoreData(1541)) {
                int i = 1;
                while (shells >= timer.getMoreData(1541) + i) {
                    timer.tryInsertNewTimeline("got_shell_" + (timer.getMoreData(1541) + i++));
                }
                timer.updateMoreData(1541, shells);
            }
            if (timer.getCategory() != RunCategories.STACK_OF_LIME_WOOL || itemStack2.method_7909() != class_1802.field_19049 || itemStack2.method_7947() != 64) continue;
            InGameTimer.complete();
        }
        List<class_1792> items = this.method_31548().method_67533().stream().map(class_1799::method_7909).toList();
        ArrayList<class_1792> armors = new ArrayList<class_1792>();
        for (Int2ObjectMap.Entry entry : class_1661.field_56551.int2ObjectEntrySet()) {
            if (((class_1304)entry.getValue()).method_5925() != class_1304.class_1305.field_6178) continue;
            armors.add(this.method_31548().method_5438(entry.getIntKey()).method_7909());
        }
        if (timer.getCategory() == RunCategories.ALL_WORKSTATIONS && items.contains(class_1802.field_16306) && items.contains(class_1802.field_16309) && items.contains(class_1802.field_16313) && items.contains(class_1802.field_8740) && items.contains(class_1802.field_17530) && items.contains(class_1802.field_16307) && items.contains(class_1802.field_16310) && items.contains(class_1802.field_8638) && items.contains(class_1802.field_16312) && items.contains(class_1802.field_16305) && items.contains(class_1802.field_8772) && items.contains(class_1802.field_16308) && items.contains(class_1802.field_16311)) {
            InGameTimer.complete();
        }
        if (timer.getCategory() == RunCategories.ALL_SWORDS && items.contains(class_1802.field_8528) && items.contains(class_1802.field_8802) && items.contains(class_1802.field_8845) && items.contains(class_1802.field_8371) && items.contains(class_1802.field_22022) && items.contains(class_1802.field_8091)) {
            InGameTimer.complete();
        }
        if (timer.getCategory() == RunCategories.ALL_MINERALS && items.contains(class_1802.field_8713) && items.contains(class_1802.field_8620) && items.contains(class_1802.field_8695) && items.contains(class_1802.field_8477) && items.contains(class_1802.field_8725) && items.contains(class_1802.field_8759) && items.contains(class_1802.field_8687) && items.contains(class_1802.field_8155) && items.contains(class_1802.field_22020) && items.contains(class_1802.field_27022) && items.contains(class_1802.field_27063)) {
            InGameTimer.complete();
        }
        if (timer.getCategory() == RunCategories.FULL_IA_15_LVL && armors.contains(class_1802.field_8743) && armors.contains(class_1802.field_8523) && armors.contains(class_1802.field_8660) && armors.contains(class_1802.field_8396) && this.field_7520 >= 15) {
            InGameTimer.complete();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void updateNausea(CallbackInfo ci) {
        if (this.field_51994 != null && this.field_51994.method_60709()) {
            if (++this.portalTick >= 81 && !InGameTimerUtils.IS_CHANGING_DIMENSION) {
                this.portalTick = 0;
                if (InGameTimer.getInstance().getStatus() != TimerStatus.IDLE && this.field_3937.method_1542()) {
                    this.latestPortalEnter = System.currentTimeMillis();
                }
            }
        } else {
            if (this.latestPortalEnter != null) {
                InGameTimer.getInstance().tryExcludeIGT(System.currentTimeMillis() - this.latestPortalEnter, "nether portal lag");
                this.latestPortalEnter = null;
            }
            this.portalTick = 0;
        }
    }

    public void method_5872(double cursorDeltaX, double cursorDeltaY) {
        InGameTimer timer;
        super.method_5872(cursorDeltaX, cursorDeltaY);
        if (!(cursorDeltaX == 0.0 && cursorDeltaY == 0.0 || (timer = InGameTimer.getInstance()).getStatus() != TimerStatus.IDLE || InGameTimerUtils.IS_CHANGING_DIMENSION)) {
            timer.setPause(false, "changed look direction");
        }
    }
}

