/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.mixins.timeline;

import com.mojang.authlib.GameProfile;
import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.instance.GameInstance;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Unique
    private class_3218 beforeWorld = null;
    @Unique
    private class_243 lastPortalPos = null;

    @Shadow
    public abstract class_3218 method_51469();

    public ServerPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method={"teleportTo(Lnet/minecraft/world/TeleportTarget;)Lnet/minecraft/server/network/ServerPlayerEntity;"}, at={@At(value="HEAD")})
    public void onChangeDimension(class_5454 target, CallbackInfoReturnable<class_1297> cir) {
        this.beforeWorld = this.method_51469();
        this.lastPortalPos = this.method_73189();
        InGameTimerUtils.IS_CAN_WAIT_WORLD_LOAD = !InGameTimer.getInstance().isCoop() && InGameTimer.getInstance().getCategory() == RunCategories.ANY;
    }

    @Inject(method={"teleportTo(Lnet/minecraft/world/TeleportTarget;)Lnet/minecraft/server/network/ServerPlayerEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;onDimensionChanged(Lnet/minecraft/entity/Entity;)V", shift=At.Shift.AFTER)})
    public void onChangedDimension(class_5454 target, CallbackInfoReturnable<class_1297> cir) {
        class_5321 oldRegistryKey = this.beforeWorld.method_27983();
        class_5321 newRegistryKey = this.method_51469().method_27983();
        InGameTimer timer = InGameTimer.getInstance();
        if (timer.getStatus() != TimerStatus.NONE) {
            if (oldRegistryKey == class_1937.field_25179 && newRegistryKey == class_1937.field_25180 && !timer.isCoop() && InGameTimer.getInstance().getCategory() == RunCategories.ANY) {
                InGameTimerUtils.IS_CAN_WAIT_WORLD_LOAD = InGameTimerUtils.isLoadableBlind((class_5321<class_1937>)class_1937.field_25180, target.comp_2821().method_1031(0.0, 0.0, 0.0), this.lastPortalPos.method_1031(0.0, 0.0, 0.0));
            }
            if (oldRegistryKey == class_1937.field_25180 && newRegistryKey == class_1937.field_25179) {
                int portalIndex = InGameTimerUtils.isBlindTraveled(this.lastPortalPos);
                boolean isNewPortal = InGameTimerUtils.isLoadableBlind((class_5321<class_1937>)class_1937.field_25179, this.lastPortalPos.method_1031(0.0, 0.0, 0.0), target.comp_2821().method_1031(0.0, 0.0, 0.0));
                if (this.isEnoughTravel()) {
                    int portalNum = InGameTimerUtils.getPortalNumber(this.lastPortalPos);
                    SpeedRunIGT.debug("Portal number: " + portalNum);
                    GameInstance.getInstance().callEvents("nether_travel", factory -> factory.getDataValue("portal").equals(String.valueOf(portalNum)));
                    timer.tryInsertNewTimeline("nether_travel");
                    if (portalIndex == 0) {
                        timer.tryInsertNewTimeline("nether_travel_home");
                    } else {
                        timer.tryInsertNewTimeline("nether_travel_blind");
                    }
                }
                if (!timer.isCoop() && InGameTimer.getInstance().getCategory() == RunCategories.ANY) {
                    InGameTimerUtils.IS_CAN_WAIT_WORLD_LOAD = isNewPortal;
                }
            }
        }
    }

    @Unique
    private boolean isEnoughTravel() {
        Set currentItemTypes = Stream.concat(this.method_31548().method_67533().stream(), Stream.of(this.method_31548().method_5438(40))).filter(Objects::nonNull).map(class_1799::method_7909).collect(Collectors.toSet());
        return currentItemTypes.contains(class_1802.field_8449) || currentItemTypes.contains(class_1802.field_8634) && (currentItemTypes.contains(class_1802.field_8894) || currentItemTypes.contains(class_1802.field_8183));
    }
}

