/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.option;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.SpeedRunIGTClient;
import com.redlimerl.speedrunigt.api.OptionButtonFactory;
import com.redlimerl.speedrunigt.option.OptionArgument;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerDrawer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.io.FileUtils;

public class SpeedRunOption {
    private static boolean isInit = false;
    private static final Path oldConfigPath = FabricLoader.getInstance().getConfigDir().resolve("speedrunigt");
    public static final Path configPath = SpeedRunIGT.getMainPath().resolve("options.txt");
    public static final Path globalConfigPath;
    private static final Path useGlobalPath;
    private static final HashMap<class_2960, String> options;
    private static boolean needSave;
    private static final ArrayList<OptionButtonFactory> optionButtonFactories;

    public static Path getConfigPath() {
        return SpeedRunOption.isUsingGlobalConfig() ? globalConfigPath : configPath;
    }

    public static boolean isUsingGlobalConfig() {
        return useGlobalPath.toFile().exists();
    }

    public static void setUseGlobalConfig(boolean b) {
        try {
            if (b) {
                FileUtils.writeStringToFile((File)useGlobalPath.toFile(), (String)"", (Charset)StandardCharsets.UTF_8);
            } else {
                FileUtils.deleteQuietly((File)useGlobalPath.toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> T getOption(OptionArgument<T> option) {
        if (!isInit) {
            SpeedRunOption.init();
        }
        return options.containsKey(option.getKey()) ? option.valueFromString(options.get(option.getKey())) : option.getDefaultValue();
    }

    public static <T> void setOption(OptionArgument<T> option, T value) {
        InGameTimerUtils.CHANGED_OPTIONS.add(option);
        options.put(option.getKey(), option.valueToString(value));
        needSave = true;
    }

    public static void checkSave() {
        if (needSave) {
            SpeedRunOption.save();
            needSave = false;
        }
    }

    public static void init() {
        if (isInit) {
            return;
        }
        try {
            options.clear();
            File optionFile = SpeedRunOption.getConfigPath().toFile();
            if (new File(oldConfigPath.toFile(), "options.txt").exists() && !optionFile.exists()) {
                File oldOptionFile = new File(oldConfigPath.toFile(), "options.txt");
                FileUtils.copyFile((File)oldOptionFile, (File)optionFile);
                FileUtils.deleteQuietly((File)oldOptionFile);
            }
            if (optionFile.exists()) {
                String optionData = FileUtils.readFileToString((File)optionFile, (Charset)StandardCharsets.UTF_8);
                for (String s : optionData.split("\n")) {
                    String[] od = s.split(":", 3);
                    if (od.length != 3) continue;
                    options.put(class_2960.method_60655((String)od[0], (String)od[1]), od[2]);
                }
            }
            isInit = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void save() {
        try {
            File config = SpeedRunOption.getConfigPath().toFile();
            StringBuilder stringBuilder = new StringBuilder();
            options.forEach((key, value) -> stringBuilder.append(key.toString()).append(":").append((String)value).append("\n"));
            FileUtils.writeStringToFile((File)config, (String)(stringBuilder.length() == 0 ? "" : stringBuilder.substring(0, stringBuilder.length() - 1)), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        isInit = false;
        SpeedRunOption.init();
        SpeedRunIGTClient.TIMER_DRAWER = new TimerDrawer(false);
    }

    public static List<OptionButtonFactory> getOptionButtonFactories() {
        return optionButtonFactories;
    }

    public static void addOptionButtonFactories(OptionButtonFactory ... factories) {
        if (SpeedRunIGTClient.isInitialized) {
            return;
        }
        optionButtonFactories.addAll(Arrays.asList(factories));
    }

    static {
        useGlobalPath = SpeedRunIGT.getMainPath().resolve(".useglobaloption");
        File globalDir = new File(System.getProperty("user.home").replace("\\", "/"), "speedrunigt");
        if (!globalDir.exists() && !globalDir.mkdirs()) {
            SpeedRunIGT.error("Failed make global config path");
        }
        globalConfigPath = globalDir.toPath().resolve("options.txt");
        options = new HashMap();
        needSave = false;
        optionButtonFactories = new ArrayList();
    }
}

