/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.crypt.Crypto;
import com.redlimerl.speedrunigt.instance.GameInstance;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.option.SpeedRunOptions;
import com.redlimerl.speedrunigt.timer.InGameTimerClientUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.TimerAdvancementTracker;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import com.redlimerl.speedrunigt.timer.category.InvalidCategoryException;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.category.RunCategory;
import com.redlimerl.speedrunigt.timer.category.condition.CategoryCondition;
import com.redlimerl.speedrunigt.timer.logs.TimerPauseLog;
import com.redlimerl.speedrunigt.timer.logs.TimerTickLog;
import com.redlimerl.speedrunigt.timer.logs.TimerTimeline;
import com.redlimerl.speedrunigt.timer.packet.TimerPacketUtils;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerChangeCategoryPacket;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerCompletePacket;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerCustomConditionPacket;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerDataConditionPacket;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerStartPacket;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerTimelinePacket;
import com.redlimerl.speedrunigt.timer.packet.packets.TimerUncompletedPacket;
import com.redlimerl.speedrunigt.timer.running.RunPortalPos;
import com.redlimerl.speedrunigt.timer.running.RunType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.class_1267;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InGameTimer
implements Serializable {
    @NotNull
    static InGameTimer INSTANCE = new InGameTimer("");
    @NotNull
    static InGameTimer COMPLETED_INSTANCE = new InGameTimer("");
    private static final String cryptKey = "faRQOs2GK5j863eP";
    private static final int DATA_VERSION = 7;
    private static final ArrayList<Consumer<InGameTimer>> onCompleteConsumers = new ArrayList();
    String worldName;
    final UUID uuid = UUID.randomUUID();
    private String category = RunCategories.ANY.getID();
    private final boolean isResettable;
    private boolean isCompleted = false;
    boolean isServerIntegrated = true;
    boolean isCoop = false;
    RunType runType = RunType.RANDOM_SEED;
    private int completeCount = 0;
    private boolean isRTAMode = false;
    private int defaultGameMode = 0;
    private boolean isCheatAvailable = false;
    long startTime = 0L;
    long endTime = 0L;
    private long endIGTTime = 0L;
    private long completeStatIGT = 0L;
    private long retimedIGTTime = 0L;
    private long rebaseIGTime = 0L;
    private long excludedRTA = 0L;
    private long excludedIGT = 0L;
    private long leastTickTime = 0L;
    private long leastStartTime = 0L;
    private long leastPauseTime = 0L;
    private long totalPauseTime = 0L;
    private int activateTicks = 0;
    Long lanOpenedTime = null;
    private long leaveTime = 0L;
    private int pauseCount = 0;
    private boolean writeFiles = true;
    private String firstInput = "";
    private final CopyOnWriteArrayList<TimerPauseLog> pauseLogList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TimerTickLog> freezeLogList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> debugLogList = new CopyOnWriteArrayList();
    private int loggerTicks = 0;
    private long loggerPausedTime = 0L;
    private int pauseTriggerTick = 0;
    private String prevPauseReason = "";
    CopyOnWriteArrayList<RunPortalPos> lastOverWorldPortalPos = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<RunPortalPos> lastNetherPortalPos = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<RunPortalPos> endPortalPosList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TimerTimeline> timelines = new CopyOnWriteArrayList();
    private final TimerAdvancementTracker advancementsTracker = new TimerAdvancementTracker();
    private boolean isHardcore = false;
    private final Integer dataVersion = 7;
    @NotNull
    private TimerStatus status = TimerStatus.NONE;
    private final ConcurrentHashMap<Integer, Integer> moreData = new ConcurrentHashMap();
    private CategoryCondition customCondition = null;
    private static boolean waitingSaveTask = false;
    private static final ExecutorService saveManagerThread = Executors.newFixedThreadPool(2);
    private String resultRecord = "";
    private long firstRenderedTime = 0L;

    @NotNull
    public static InGameTimer getInstance() {
        return INSTANCE;
    }

    public static void onComplete(Consumer<InGameTimer> supplier) {
        onCompleteConsumers.add(supplier);
    }

    public InGameTimer(String worldName) {
        this(worldName, true);
    }

    public InGameTimer(String worldName, boolean isResettable) {
        this.worldName = worldName;
        this.isResettable = isResettable;
    }

    public static void start(String worldName, RunType runType) {
        if (!InGameTimer.INSTANCE.worldName.isEmpty()) {
            INSTANCE.writeRecordFile(false);
        }
        INSTANCE = new InGameTimer(worldName);
        INSTANCE.setCategory(SpeedRunOption.getOption(SpeedRunOptions.TIMER_CATEGORY), false);
        INSTANCE.setPause(true, TimerStatus.IDLE, "startup");
        InGameTimer.INSTANCE.runType = runType;
        InGameTimerUtils.STATS_UPDATE = null;
        GameInstance.getInstance().tryLoadWorld(worldName);
        if (runType.equals((Object)RunType.SET_SEED)) {
            GameInstance.getInstance().callEvents("view_seed");
        } else if (runType.equals((Object)RunType.OLD_WORLD)) {
            GameInstance.getInstance().callEvents("old_world");
        }
    }

    public static void reset() {
        RunType runType = INSTANCE.getRunType();
        boolean isCoop = InGameTimer.INSTANCE.isCoop;
        int defaultGameMode = InGameTimer.INSTANCE.defaultGameMode;
        boolean isCheatAvailable = InGameTimer.INSTANCE.isCheatAvailable;
        INSTANCE = new InGameTimer(InGameTimer.INSTANCE.worldName, false);
        INSTANCE.setCategory(RunCategories.CUSTOM, false);
        InGameTimer.INSTANCE.runType = runType;
        InGameTimer.INSTANCE.isCoop = isCoop;
        InGameTimer.INSTANCE.isCheatAvailable = isCheatAvailable;
        InGameTimer.INSTANCE.defaultGameMode = defaultGameMode;
        INSTANCE.setPause(true, TimerStatus.IDLE, "reset");
        INSTANCE.setPause(false, "reset");
        InGameTimerUtils.STATS_UPDATE = null;
        if (isCoop && SpeedRunIGT.IS_CLIENT_SIDE) {
            TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerStartPacket(INSTANCE, INSTANCE.getRealTimeAttack()));
        }
    }

    public static void end() {
        INSTANCE.setStatus(TimerStatus.NONE);
    }

    public static void complete() {
        InGameTimer.complete(System.currentTimeMillis(), true);
    }

    public static synchronized void complete(long endTime, boolean canSendPacket) {
        Long inGameTime;
        if (InGameTimer.INSTANCE.isCompleted || !INSTANCE.isStarted()) {
            return;
        }
        InGameTimer.INSTANCE.isHardcore = InGameTimerUtils.isHardcoreWorld();
        COMPLETED_INSTANCE = (InGameTimer)new Gson().fromJson(new Gson().toJson((Object)INSTANCE), InGameTimer.class);
        InGameTimer.INSTANCE.isCompleted = true;
        InGameTimer timer = COMPLETED_INSTANCE;
        timer.endTime = endTime;
        timer.endIGTTime = timer.endTime - timer.leastTickTime;
        if (timer.isServerIntegrated && SpeedRunIGT.IS_CLIENT_SIDE && (inGameTime = InGameTimerClientUtils.getPlayerTime()) != null) {
            timer.completeStatIGT = inGameTime;
            InGameTimer.INSTANCE.completeStatIGT = inGameTime;
        }
        timer.setStatus(TimerStatus.COMPLETED_LEGACY);
        if (timer.isCoop() && canSendPacket && SpeedRunIGT.IS_CLIENT_SIDE) {
            TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerCompletePacket(timer.getRealTimeAttack()));
        }
        if (InGameTimer.INSTANCE.isServerIntegrated) {
            InGameTimer.writeTimerLogs(timer);
        }
        ++InGameTimer.INSTANCE.completeCount;
        INSTANCE.updateRecordString();
        INSTANCE.writeRecordFile(false);
        InGameTimerUtils.LATEST_TIMER_TIME = System.currentTimeMillis();
        for (Consumer<InGameTimer> onCompleteConsumer : onCompleteConsumers) {
            try {
                onCompleteConsumer.accept(timer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeTimerLogs(InGameTimer timer) {
        InGameTimer.writeTimerLogs(timer, false);
    }

    public static void writeTimerLogs(InGameTimer timer, boolean anyPercentSplit) {
        if (!timer.writeFiles) {
            return;
        }
        String worldName = InGameTimer.INSTANCE.worldName;
        File worldDir = InGameTimerUtils.getTimerLogDir(worldName, "logs");
        if (worldDir == null) {
            return;
        }
        String logSuffix = anyPercentSplit ? "_any%_split.log" : timer.getLogSuffix();
        File advancementFile = new File(worldDir, "igt_advancement" + logSuffix);
        File pauseFile = new File(worldDir, "igt_timer" + logSuffix);
        File tickFile = new File(worldDir, "igt_freeze" + logSuffix);
        File categoryFile = new File(worldDir, "igt_category" + logSuffix);
        File debugFile = new File(worldDir, "igt_debug.txt");
        if (anyPercentSplit && pauseFile.exists()) {
            return;
        }
        StringBuilder resultLog = new StringBuilder();
        boolean isRetimed = timer.getRetimedInGameTime(anyPercentSplit) != timer.getInGameTime(false);
        resultLog.append("Result > IGT: ").append(InGameTimerUtils.timeToStringFormat(timer.getInGameTime(false)));
        if (isRetimed) {
            resultLog.append(", Auto-Retimed IGT: ").append(InGameTimerUtils.timeToStringFormat(timer.getRetimedInGameTime(anyPercentSplit)));
        }
        resultLog.append(", RTA: ").append(InGameTimerUtils.timeToStringFormat(timer.getRealTimeAttack())).append(", Counted Ticks: ").append(timer.activateTicks).append(", Total Ticks: ").append(timer.loggerTicks);
        if (isRetimed) {
            resultLog.append(", Auto-Retimed IGT Length: ").append(InGameTimerUtils.timeToStringFormat(timer.retimedIGTTime));
        }
        resultLog.append(", Excluded RTA Time: ").append(InGameTimerUtils.timeToStringFormat(timer.excludedRTA));
        resultLog.append(", Excluded IGT Time: ").append(InGameTimerUtils.timeToStringFormat(timer.excludedIGT));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd HH:mm:ss");
        String logInfo = "====================\r\n" + String.valueOf(resultLog) + "\r\n" + timer.firstInput + "\r\nMC Version : " + InGameTimerUtils.getMinecraftVersion() + "\r\nTimer Version : " + SpeedRunIGT.MOD_VERSION + "\r\nRun Date : " + simpleDateFormat.format(new Date());
        String advancementLog = SpeedRunIGT.GSON.toJson(timer.getAdvancementsTracker().getAdvancements());
        String pauseLog = InGameTimerUtils.pauseLogListToString(timer.pauseLogList, !pauseFile.exists(), pauseFile.exists() ? 0 : timer.completeCount) + logInfo;
        String freezeLog = InGameTimerUtils.logListToString(timer.freezeLogList, tickFile.exists() ? 0 : timer.completeCount);
        String categoryRaw = timer.getCategory().getConditionJson() != null ? SpeedRunIGT.PRETTY_GSON.toJson((JsonElement)timer.getCategory().getConditionJson()) : "";
        String debugRaw = StringUtils.join(timer.debugLogList.iterator(), (char)'\n');
        if (!anyPercentSplit) {
            timer.freezeLogList.clear();
            timer.pauseLogList.clear();
            timer.debugLogList.clear();
        }
        saveManagerThread.submit(() -> {
            try {
                FileUtils.writeStringToFile((File)advancementFile, (String)advancementLog, (Charset)StandardCharsets.UTF_8);
                FileUtils.writeStringToFile((File)pauseFile, (String)pauseLog, (Charset)StandardCharsets.UTF_8, (boolean)true);
                FileUtils.writeStringToFile((File)tickFile, (String)freezeLog, (Charset)StandardCharsets.UTF_8, (boolean)true);
                if (SpeedRunIGT.IS_DEBUG_MODE) {
                    FileUtils.writeStringToFile((File)debugFile, (String)debugRaw, (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                if (!categoryRaw.isEmpty()) {
                    FileUtils.writeStringToFile((File)categoryFile, (String)categoryRaw, (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                SpeedRunIGT.error("Failed to save timer logs :( RTA : " + InGameTimerUtils.timeToStringFormat(timer.getRealTimeAttack()) + " / IGT : " + InGameTimerUtils.timeToStringFormat(timer.getInGameTime(false)));
            }
        });
        if (SpeedRunOption.getOption(SpeedRunOptions.AUTO_SAVE_PLAYER_DATA).booleanValue() && InGameTimerUtils.getServer() != null && !anyPercentSplit) {
            InGameTimerUtils.getServer().method_3760().method_14617();
        }
    }

    public static void leave() {
        if (!InGameTimer.INSTANCE.isServerIntegrated) {
            return;
        }
        InGameTimer.INSTANCE.leaveTime = System.currentTimeMillis();
        InGameTimer.INSTANCE.pauseCount = 0;
        INSTANCE.setPause(true, TimerStatus.LEAVE, "leave the world");
        InGameTimer.save(true);
        GameInstance.getInstance().closeTimer();
        InGameTimerUtils.STATS_UPDATE = null;
        INSTANCE.setStatus(TimerStatus.NONE);
    }

    private static void save() {
        InGameTimer.save(false);
    }

    private static synchronized void save(boolean withLeave) {
        if (waitingSaveTask || saveManagerThread.isShutdown() || saveManagerThread.isTerminated() || !InGameTimer.INSTANCE.isServerIntegrated || InGameTimer.INSTANCE.worldName.isEmpty() || !InGameTimer.INSTANCE.writeFiles) {
            return;
        }
        String worldName = InGameTimer.INSTANCE.worldName;
        String timerData = SpeedRunIGT.GSON.toJson((Object)INSTANCE);
        String completeData = SpeedRunIGT.GSON.toJson((Object)COMPLETED_INSTANCE);
        File worldDir = InGameTimerUtils.getTimerLogDir(worldName, "data");
        if (worldDir == null) {
            SpeedRunIGT.debug("Tried to saving timer data, but couldn't find world directory");
            return;
        }
        if (withLeave) {
            InGameTimer.end();
        }
        SpeedRunIGT.debug("Start timer data saving...");
        waitingSaveTask = true;
        saveManagerThread.submit(() -> {
            try {
                if (worldDir.exists()) {
                    File timerFile = new File(worldDir, "timer.igt");
                    File timerCompleteFile = new File(worldDir, "timer.c.igt");
                    File oldTimerFile = new File(worldDir, "timer.igt.old");
                    File oldTimerCompleteFile = new File(worldDir, "timer.c.igt.old");
                    if (timerFile.exists()) {
                        if (oldTimerFile.exists()) {
                            FileUtils.forceDelete((File)oldTimerFile);
                            SpeedRunIGT.debug("deleted old backup timer data");
                        }
                        FileUtils.moveFile((File)timerFile, (File)oldTimerFile);
                        SpeedRunIGT.debug("renamed backup timer data");
                        if (timerCompleteFile.exists()) {
                            if (oldTimerCompleteFile.exists()) {
                                FileUtils.forceDelete((File)oldTimerCompleteFile);
                                SpeedRunIGT.debug("deleted old backup timer data *c");
                            }
                            FileUtils.moveFile((File)timerCompleteFile, (File)oldTimerCompleteFile);
                            SpeedRunIGT.debug("renamed backup timer data *c");
                        } else if (oldTimerCompleteFile.exists()) {
                            FileUtils.deleteQuietly((File)oldTimerCompleteFile);
                            SpeedRunIGT.debug("deleted old backup timer data *c");
                        }
                    }
                    SpeedRunIGT.debug("Timer data target path: " + timerFile.getPath());
                    FileUtils.writeStringToFile((File)timerFile, (String)Crypto.encrypt(timerData, cryptKey), (Charset)StandardCharsets.UTF_8);
                    if (InGameTimer.INSTANCE.isCompleted) {
                        FileUtils.writeStringToFile((File)timerCompleteFile, (String)Crypto.encrypt(completeData, cryptKey), (Charset)StandardCharsets.UTF_8);
                    }
                    SpeedRunIGT.debug("End timer data saving...");
                } else {
                    SpeedRunIGT.debug("Doesn't exist world directory: " + worldDir.getPath());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                SpeedRunIGT.error("Failed to save timer data's :(");
            }
            finally {
                waitingSaveTask = false;
            }
        });
    }

    public static boolean load(String name) {
        File worldDir = InGameTimerUtils.getTimerLogDir(name, "data");
        if (worldDir == null) {
            return false;
        }
        SpeedRunIGT.debug("Start timer data loading...");
        String isOld = "";
        while (true) {
            File file = new File(worldDir, "timer.igt" + isOld);
            File completeFile = new File(worldDir, "timer.c.igt" + isOld);
            SpeedRunIGT.debug("Loading timer data target path: " + file.getPath());
            if (!file.exists()) break;
            try {
                INSTANCE = (InGameTimer)SpeedRunIGT.GSON.fromJson(Crypto.decrypt(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), cryptKey), InGameTimer.class);
                if (completeFile.exists()) {
                    COMPLETED_INSTANCE = (InGameTimer)SpeedRunIGT.GSON.fromJson(Crypto.decrypt(FileUtils.readFileToString((File)completeFile, (Charset)StandardCharsets.UTF_8), cryptKey), InGameTimer.class);
                }
                SpeedRunIGT.debug("Loaded Timer Saved Data! " + isOld);
                INSTANCE.setStatus(TimerStatus.LEAVE);
                if (InGameTimer.INSTANCE.dataVersion == null || InGameTimer.INSTANCE.dataVersion == 0 || InGameTimer.INSTANCE.dataVersion != 7) {
                    FileUtils.moveFile((File)file, (File)new File(worldDir, "timer.igt.backup"));
                    SpeedRunIGT.error("The timer data has found, but it is an old version. timer file is renamed to \"*.igt.backup\"");
                    InGameTimer.start(name, RunType.OLD_WORLD);
                    return true;
                }
                InGameTimer.INSTANCE.worldName = name;
                InGameTimer.COMPLETED_INSTANCE.worldName = name;
                GameInstance.getInstance().tryLoadWorld(name);
                INSTANCE.getCustomCondition().ifPresent(CategoryCondition::refreshConditionClasses);
                InGameTimerUtils.STATS_UPDATE = null;
                SpeedRunIGT.debug("End timer data loading...");
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!isOld.isEmpty()) {
                    return false;
                }
                isOld = ".old";
                continue;
            }
            break;
        }
        if (SpeedRunOption.getOption(SpeedRunOptions.TIMER_START_GENERATED_WORLD).booleanValue() && isOld.isEmpty()) {
            InGameTimer.start(name, RunType.OLD_WORLD);
            SpeedRunIGT.error("Couldn't find any file, created new timer.");
            return true;
        }
        InGameTimer.INSTANCE.worldName = name;
        InGameTimer.COMPLETED_INSTANCE.worldName = name;
        GameInstance.getInstance().tryLoadWorld(name);
        return false;
    }

    private void updateRecordString() {
        this.resultRecord = SpeedRunIGT.PRETTY_GSON.toJson((JsonElement)InGameTimerUtils.convertTimelineJson(this));
    }

    public void writeRecordFile(boolean worldOnly) {
        File worldRecordFile;
        File recordFile = new File(SpeedRunIGT.getRecordsPath().toFile(), String.valueOf(this.uuid) + ".json");
        File worldFile = InGameTimerUtils.getTimerLogDir(this.worldName, "");
        if (worldFile == null && this.isServerIntegrated) {
            return;
        }
        File file = worldRecordFile = !this.isServerIntegrated ? null : new File(worldFile, "record.json");
        if (this.resultRecord.isEmpty()) {
            return;
        }
        SpeedRunOptions.RecordGenerateType optionType = SpeedRunOption.getOption(SpeedRunOptions.GENERATE_RECORD_FILE);
        if (optionType == SpeedRunOptions.RecordGenerateType.NONE || optionType == SpeedRunOptions.RecordGenerateType.COMPLETE_ONLY && !this.isCompleted()) {
            return;
        }
        saveManagerThread.submit(() -> {
            try {
                if (!worldOnly && this.writeFiles) {
                    FileUtils.writeStringToFile((File)recordFile, (String)this.resultRecord, (Charset)StandardCharsets.UTF_8);
                }
                if (worldRecordFile != null) {
                    FileUtils.writeStringToFile((File)worldRecordFile, (String)this.resultRecord, (Charset)StandardCharsets.UTF_8);
                }
                System.setProperty("speedrunigt.record", recordFile.getName());
                SpeedRunIGT.debug("Saved record file" + (worldOnly ? "" : "s (with global save)"));
            }
            catch (IOException e) {
                e.printStackTrace();
                SpeedRunIGT.error("Failed to write timer record :(");
            }
            finally {
                SpeedRunIGT.debug("Done with saving record file");
            }
        });
    }

    @NotNull
    public RunCategory getCategory() {
        return RunCategory.getCategory(this.category);
    }

    public void setCategory(RunCategory category, boolean canSendPacket) {
        this.category = category.getID();
        if (category.getConditionJson() != null) {
            try {
                this.customCondition = new CategoryCondition(category.getConditionJson());
            }
            catch (InvalidCategoryException exception) {
                InGameTimerUtils.setCategoryWarningScreen(category.getConditionFileName(), exception);
            }
        }
        if (this.isCoop() && canSendPacket && SpeedRunIGT.IS_CLIENT_SIDE) {
            TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerChangeCategoryPacket(this.getCategory()));
        }
    }

    public boolean isCoop() {
        return this.isCoop;
    }

    public long getTicks() {
        return this.activateTicks;
    }

    public long getTotalTicks() {
        return this.loggerTicks;
    }

    public long getLatestPauseTime() {
        return this.leastPauseTime;
    }

    public long getTotalPauseTime() {
        return this.totalPauseTime;
    }

    public int getMoreData(int key) {
        return this.moreData.getOrDefault(key, 0);
    }

    public Enumeration<Integer> getMoreDataKeys() {
        return this.moreData.keys();
    }

    public void updateMoreData(int key, int value) {
        this.updateMoreData(key, value, true);
    }

    public void updateMoreData(int key, int value, boolean canSendPacket) {
        this.moreData.put(key, value);
        if (this.isCoop() && canSendPacket && SpeedRunIGT.IS_CLIENT_SIDE) {
            TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerDataConditionPacket(key, value));
        }
    }

    @NotNull
    public TimerStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull TimerStatus status) {
        if (this.getStatus() == TimerStatus.COMPLETED_LEGACY && status != TimerStatus.NONE) {
            return;
        }
        this.status = status;
    }

    public void setUncompleted(boolean canSendPacket) {
        if (!this.isCompleted) {
            return;
        }
        this.isCompleted = false;
        if (canSendPacket && this.isCoop() && SpeedRunIGT.IS_CLIENT_SIDE) {
            TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerUncompletedPacket());
        }
    }

    public boolean isCompleted() {
        return this.isCompleted || this.getStatus() == TimerStatus.COMPLETED_LEGACY;
    }

    public int getPauseCount() {
        return this.pauseCount;
    }

    public boolean isStarted() {
        return this.startTime != 0L;
    }

    public boolean isStopped() {
        return this.getStatus() == TimerStatus.LEAVE || this.getStatus() == TimerStatus.NONE;
    }

    public boolean isPaused() {
        return this.getStatus() != TimerStatus.COMPLETED_LEGACY && this.getStatus().getPause() > 0;
    }

    public boolean isPlaying() {
        return !this.isPaused() && this.getStatus() != TimerStatus.COMPLETED_LEGACY && this.getStatus() != TimerStatus.NONE;
    }

    public long getEndTime() {
        return this.getStatus() == TimerStatus.COMPLETED_LEGACY ? this.endTime : System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.isStarted() ? this.startTime : System.currentTimeMillis();
    }

    public long getRealTimeAttack() {
        return this.isCompleted && this != COMPLETED_INSTANCE ? COMPLETED_INSTANCE.getRealTimeAttack() : (this.getStatus() == TimerStatus.NONE ? 0L : this.getEndTime() - this.getStartTime() - this.excludedRTA);
    }

    public long getInGameTime() {
        return this.getInGameTime(true);
    }

    public long getInGameTime(boolean smooth) {
        if (this.isCompleted && this != COMPLETED_INSTANCE) {
            return COMPLETED_INSTANCE.getInGameTime(smooth);
        }
        if (this.isRTAMode) {
            return this.getRealTimeAttack();
        }
        long ms = System.currentTimeMillis();
        return !this.isStarted() ? 0L : this.getTicks() * 50L + Math.min(50L, smooth && this.isPlaying() && this.leastTickTime != 0L ? ms - this.leastTickTime : 0L) - this.rebaseIGTime - this.excludedIGT + this.endIGTTime;
    }

    public long getRetimedInGameTime() {
        return this.getRetimedInGameTime(false);
    }

    public long getRetimedInGameTime(boolean override) {
        boolean needAutoRetime;
        long base = this.getInGameTime(false);
        boolean bl = needAutoRetime = override ? this.getCategory().isNeedAutoRetime(this, RunCategories.anyPercentRetime) : this.getCategory().isNeedAutoRetime(this);
        if (needAutoRetime) {
            return base + this.retimedIGTTime;
        }
        return base;
    }

    public void updateFirstInput() {
        if (this.firstInput.isEmpty() && SpeedRunOption.getOption(SpeedRunOptions.WAITING_FIRST_INPUT).isWorldLoad(this)) {
            this.firstInput = "First Input: IGT " + InGameTimerUtils.timeToStringFormat(this.getInGameTime(false)) + (String)(this.leastTickTime == 0L ? "" : " (+ " + (System.currentTimeMillis() - this.leastTickTime) + "ms)") + ", RTA " + InGameTimerUtils.timeToStringFormat(this.getRealTimeAttack());
        }
        if (this.firstRenderedTime != 0L) {
            this.firstInput = "First World Rendered: " + InGameTimerUtils.millisecondToStringFormat(System.currentTimeMillis() - this.firstRenderedTime) + "ms before first input";
        }
    }

    public void updateFirstRendered() {
        if (this.firstInput.isEmpty() && this.firstRenderedTime == 0L && SpeedRunOption.getOption(SpeedRunOptions.WAITING_FIRST_INPUT).isFirstInput(this)) {
            this.firstRenderedTime = System.currentTimeMillis();
        }
    }

    public void tick() {
        if (this.getStatus() == TimerStatus.COMPLETED_LEGACY) {
            return;
        }
        if (this.isPlaying()) {
            ++this.activateTicks;
        }
        ++this.loggerTicks;
        long currentTime = System.currentTimeMillis();
        long tickDelays = currentTime - this.leastTickTime;
        if (this.leastStartTime != 0L && this.leastTickTime != 0L && this.leastStartTime != currentTime) {
            double value = class_3532.method_15350((double)((double)(this.leastStartTime - this.leastTickTime) * 1.0 / (double)tickDelays), (double)0.0, (double)1.0) * 50.0;
            this.rebaseIGTime += (long)value;
            this.leastStartTime = 0L;
        }
        this.leastTickTime = currentTime;
        if (tickDelays != currentTime && Math.abs(50L - tickDelays) > 4L && !this.isCoop()) {
            this.freezeLogList.add(new TimerTickLog(this.activateTicks, this.loggerTicks, this.getRealTimeAttack(), tickDelays, this.getInGameTime(false), this.getStatus() == TimerStatus.IDLE));
            if (this.freezeLogList.size() >= 1000) {
                if (this.isServerIntegrated && this.writeFiles) {
                    File worldDir = InGameTimerUtils.getTimerLogDir(this.worldName, "logs");
                    if (worldDir == null) {
                        return;
                    }
                    File tickFile = new File(worldDir, "igt_freeze" + this.getLogSuffix());
                    String freezeLog = InGameTimerUtils.logListToString(this.freezeLogList, tickFile.exists() ? 0 : this.completeCount);
                    saveManagerThread.submit(() -> {
                        try {
                            FileUtils.writeStringToFile((File)tickFile, (String)freezeLog, (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            SpeedRunIGT.error("Failed to clear freeze logs and saves");
                        }
                    });
                }
                this.freezeLogList.clear();
            }
        }
        if (SpeedRunOption.getOption(SpeedRunOptions.TIMER_DATA_AUTO_SAVE) == SpeedRunOptions.TimerSaveInterval.TICKS) {
            InGameTimer.save();
        }
    }

    public void setPause(boolean isPause, String reason) {
        this.setPause(isPause, TimerStatus.PAUSED, reason);
    }

    public void setPause(boolean toPause, TimerStatus toStatus, String reason) {
        if ((this.getStatus() == TimerStatus.COMPLETED_LEGACY || this.isCoop()) && (!this.isCoop() || toPause || this.isStarted())) {
            return;
        }
        SpeedRunIGT.debug("Paused: " + toPause + " (" + toStatus.name() + ") / Reason : " + reason);
        if (toPause) {
            if (this.getStatus().getPause() <= toStatus.getPause()) {
                GameInstance.getInstance().ensureWorld();
                if (this.getStatus().getPause() < 1 && this.isStarted()) {
                    this.loggerPausedTime = this.getRealTimeAttack();
                    this.prevPauseReason = reason;
                    ++this.pauseCount;
                }
                InGameTimerUtils.CHANGED_OPTIONS.clear();
                InGameTimerUtils.RETIME_IS_WAITING_LOAD = false;
                if (this.pauseTriggerTick == this.loggerTicks) {
                    this.tick();
                }
                this.pauseTriggerTick = this.loggerTicks;
                this.setStatus(toStatus);
                this.updateRecordString();
                if (this.isStarted()) {
                    if (SpeedRunOption.getOption(SpeedRunOptions.TIMER_DATA_AUTO_SAVE) == SpeedRunOptions.TimerSaveInterval.PAUSE && this.status != TimerStatus.LEAVE) {
                        InGameTimer.save();
                    }
                    this.writeRecordFile(true);
                }
            }
        } else {
            if (this.isStarted()) {
                long nowTime = this.getRealTimeAttack();
                long beforeRetime = this.retimedIGTTime;
                TimerPauseLog.Retime retime = new TimerPauseLog.Retime(0L, "");
                if (this.getStatus() == TimerStatus.PAUSED) {
                    if (InGameTimerUtils.RETIME_IS_WAITING_LOAD && InGameTimerUtils.IS_CAN_WAIT_WORLD_LOAD) {
                        retime = new TimerPauseLog.Retime(this.retimedIGTTime - beforeRetime, "prob. world load pause");
                    } else if (!InGameTimerUtils.CHANGED_OPTIONS.isEmpty()) {
                        int options = InGameTimerUtils.CHANGED_OPTIONS.size();
                        this.retimedIGTTime += Math.max(nowTime - this.loggerPausedTime - 5000L, 0L);
                        retime = new TimerPauseLog.Retime(this.retimedIGTTime - beforeRetime, "changed option" + (String)(options > 1 ? "s (" + options + ")" : ""));
                        InGameTimerUtils.CHANGED_OPTIONS.clear();
                    } else {
                        this.retimedIGTTime += nowTime - this.loggerPausedTime;
                        retime = new TimerPauseLog.Retime(this.retimedIGTTime - beforeRetime, "");
                    }
                }
                if (this.isPaused()) {
                    this.leastPauseTime = nowTime - this.loggerPausedTime;
                    this.totalPauseTime += this.leastPauseTime;
                    this.pauseLogList.add(new TimerPauseLog(this.prevPauseReason, reason, this.getInGameTime(false), this.getRealTimeAttack(), this.leastPauseTime, this.pauseCount, retime));
                    if (this.pauseLogList.size() >= 100) {
                        if (this.isServerIntegrated && this.writeFiles) {
                            File worldDir = InGameTimerUtils.getTimerLogDir(this.worldName, "logs");
                            if (worldDir == null) {
                                return;
                            }
                            File pauseFile = new File(worldDir, "igt_timer" + this.getLogSuffix());
                            String pauseLog = InGameTimerUtils.pauseLogListToString(this.pauseLogList, !pauseFile.exists(), pauseFile.exists() ? 0 : this.completeCount);
                            saveManagerThread.submit(() -> {
                                try {
                                    FileUtils.writeStringToFile((File)pauseFile, (String)pauseLog, (Charset)StandardCharsets.UTF_8, (boolean)true);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    SpeedRunIGT.error("Failed to write pause log for clearing logs");
                                }
                            });
                        }
                        this.pauseLogList.clear();
                    }
                    this.setCheatAvailable(InGameTimerUtils.isCurrentWorldCheatAvailable());
                    this.setDefaultGameMode(InGameTimerUtils.getCurrentWorldDefaultGameMode());
                    if (this.getCategory().canSegment() && this.leaveTime != 0L && this.leaveTime > this.startTime) {
                        this.excludedRTA += System.currentTimeMillis() - this.leaveTime;
                    }
                    this.leaveTime = 0L;
                }
                if (this.getStatus() == TimerStatus.IDLE && this.loggerTicks != 0) {
                    this.leastStartTime = System.currentTimeMillis();
                }
            } else {
                this.startTime = System.currentTimeMillis();
                if (SpeedRunOption.getOption(SpeedRunOptions.TIMER_LEGACY_IGT_MODE).booleanValue()) {
                    InGameTimer.save();
                }
                if (this.loggerTicks != 0) {
                    this.leastStartTime = this.startTime;
                }
                if (this.isCoop()) {
                    if (SpeedRunIGT.IS_CLIENT_SIDE) {
                        TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerStartPacket(InGameTimer.getInstance(), 0L));
                    } else {
                        TimerPacketUtils.sendServer2ClientPacket(SpeedRunIGT.DEDICATED_SERVER, new TimerStartPacket(InGameTimer.getInstance(), 0L));
                    }
                }
            }
            this.checkDifficulty(InGameTimerUtils.getCurrentDifficulty());
            this.setStatus(TimerStatus.RUNNING);
        }
    }

    public boolean isResettable() {
        return this.isResettable || SpeedRunOption.getOption(SpeedRunOptions.TIMER_LIMITLESS_RESET) != false;
    }

    public boolean tryInsertNewTimeline(String name) {
        return this.tryInsertNewTimeline(name, true);
    }

    public boolean tryInsertNewTimeline(String name, boolean canSendPacket) {
        GameInstance.getInstance().callEvents("insert_timeline", factory -> name.equalsIgnoreCase(factory.getDataValue("timeline")));
        for (TimerTimeline timeline : this.timelines) {
            if (!Objects.equals(timeline.getName(), name)) continue;
            return false;
        }
        this.timelines.add(new TimerTimeline(name, this.getInGameTime(false), this.getRealTimeAttack()));
        if (canSendPacket && this.isCoop() && SpeedRunIGT.IS_CLIENT_SIDE) {
            TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerTimelinePacket(name));
        }
        return true;
    }

    public void tryInsertNewAdvancement(String advancementID, String criteriaKey, boolean isAdvancement) {
        TimerAdvancementTracker.AdvancementTrack advancementTrack = this.advancementsTracker.getOrCreateTrack(advancementID);
        if (criteriaKey == null) {
            if (advancementTrack.isComplete()) {
                return;
            }
            advancementTrack.setComplete(true);
            advancementTrack.setTime(this.getInGameTime(false), this.getRealTimeAttack());
        } else {
            advancementTrack.addCriteria(criteriaKey, this.getInGameTime(false), this.getRealTimeAttack());
        }
        advancementTrack.setAdvancement(isAdvancement);
    }

    public List<TimerTimeline> getTimelines() {
        return this.timelines;
    }

    public TimerAdvancementTracker getAdvancementsTracker() {
        return this.advancementsTracker;
    }

    public boolean isHardcore() {
        return this.isHardcore;
    }

    public RunType getRunType() {
        return this.runType;
    }

    String getLogSuffix() {
        return InGameTimer.getLogSuffix(this.completeCount);
    }

    static String getLogSuffix(int count) {
        return (String)(count == 0 ? "" : "_" + count) + ".log";
    }

    public void openedLanIntegratedServer() {
        GameInstance.getInstance().callEvents("multiplayer");
        this.lanOpenedTime = this.getRealTimeAttack();
    }

    public boolean isOpenedIntegratedServer() {
        return this.lanOpenedTime != null;
    }

    public void checkConditions() {
        if (this.getCustomCondition().map(CategoryCondition::isDone).orElse(false).booleanValue()) {
            InGameTimer.complete();
        }
    }

    public <T> void updateCondition(CategoryCondition.Condition<T> condition, T check) {
        if (condition.isCompleted()) {
            return;
        }
        boolean completed = condition.checkConditionComplete(check);
        if (completed) {
            condition.setCompleted(true);
            this.tryInsertNewTimeline(condition.getName());
            if (this.isCoop() && SpeedRunIGT.IS_CLIENT_SIDE) {
                TimerPacketUtils.sendClient2ServerPacket(class_310.method_1551(), new TimerCustomConditionPacket(condition));
            }
        }
    }

    public Optional<CategoryCondition> getCustomCondition() {
        return Optional.ofNullable(this.customCondition);
    }

    public List<RunPortalPos> getNetherPortalPosList() {
        return this.lastNetherPortalPos;
    }

    public List<RunPortalPos> getOverWorldPortalPosList() {
        return this.lastOverWorldPortalPos;
    }

    public void setServerIntegrated(boolean serverIntegrated) {
        this.isServerIntegrated = serverIntegrated;
    }

    public void setCoop(boolean coop) {
        this.isCoop = coop;
        if (coop) {
            this.setRTAMode(true);
        }
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public CopyOnWriteArrayList<RunPortalPos> getEndPortalPosList() {
        return this.endPortalPosList;
    }

    public void setWriteFiles(boolean writeFiles) {
        this.writeFiles = writeFiles;
    }

    public void tryExcludeIGT(long igt, String reason) {
        this.excludedIGT += igt;
        System.out.printf("[SpeedRunIGT] this play seems to be caught in specific lag(%s). excluded IGT for this time: .%s", reason, igt);
    }

    public boolean isRTAMode() {
        return this.isRTAMode;
    }

    public void setRTAMode(boolean RTAMode) {
        this.isRTAMode = RTAMode;
    }

    public Long getCompleteStatIGT() {
        return this.completeStatIGT;
    }

    public int getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public void setDefaultGameMode(int defaultGameMode) {
        if (defaultGameMode != 0) {
            GameInstance.getInstance().callEvents("enable_cheats");
        }
        this.defaultGameMode = defaultGameMode;
    }

    public void checkDifficulty(class_1267 difficulty) {
        if (difficulty.equals((Object)class_1267.field_5801)) {
            GameInstance.getInstance().callEvents("enable_cheats");
        }
    }

    public boolean isCheatAvailable() {
        return this.isCheatAvailable;
    }

    public void setCheatAvailable(boolean cheatAvailable) {
        if (cheatAvailable) {
            GameInstance.getInstance().callEvents("enable_cheats");
        }
        this.isCheatAvailable = cheatAvailable;
    }

    public String getWorldName() {
        return this.worldName;
    }
}

