/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer.packet.packets;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.category.RunCategory;
import com.redlimerl.speedrunigt.timer.packet.TimerPacket;
import com.redlimerl.speedrunigt.timer.running.RunType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class TimerInitializePacket
extends TimerPacket<TimerInitializePacket> {
    public static final class_8710.class_9154<TimerInitializePacket> IDENTIFIER = TimerPacket.identifier("timer_init");
    public static final class_9139<class_9129, TimerInitializePacket> CODEC = TimerPacket.codecOf(TimerInitializePacket::write, TimerInitializePacket::new);
    private final RunType runType;
    private final RunCategory category;

    public TimerInitializePacket(InGameTimer timer) {
        super(IDENTIFIER);
        if (timer != null) {
            this.runType = timer.getRunType();
            this.category = timer.getCategory();
        } else {
            this.runType = RunType.RANDOM_SEED;
            this.category = RunCategories.ANY;
        }
    }

    public TimerInitializePacket(class_9129 buf) {
        super(IDENTIFIER);
        this.runType = RunType.fromInt(buf.readInt());
        this.category = RunCategory.getCategory(buf.method_19772());
    }

    @Override
    protected void write(class_9129 buf) {
        buf.method_53002(this.runType.getCode());
        buf.method_10814(this.category.getID());
    }

    @Override
    public void receiveClient2ServerPacket(MinecraftServer server) {
        if (!SpeedRunIGT.IS_CLIENT_SIDE) {
            this.init(true);
        }
        this.sendPacketToPlayers(server);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void receiveServer2ClientPacket(class_310 client) {
        this.init(client.method_1496());
    }

    private void init(boolean isIntegrated) {
        InGameTimer.start("", this.runType);
        InGameTimer.getInstance().setStartTime(0L);
        InGameTimer.getInstance().setCategory(this.category, false);
        InGameTimer.getInstance().setCoop(true);
        InGameTimer.getInstance().setServerIntegrated(isIntegrated);
    }
}

