/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.timer.packet.packets;

import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.category.RunCategory;
import com.redlimerl.speedrunigt.timer.packet.TimerPacket;
import com.redlimerl.speedrunigt.timer.running.RunType;
import java.util.Enumeration;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class TimerStartPacket
extends TimerPacket<TimerStartPacket> {
    public static final class_8710.class_9154<TimerStartPacket> IDENTIFIER = TimerPacket.identifier("timer_start");
    public static final class_9139<class_9129, TimerStartPacket> CODEC = TimerPacket.codecOf(TimerStartPacket::write, TimerStartPacket::new);
    private final UUID timerUuid;
    private final RunType runType;
    private final RunCategory category;
    private final String customData;
    private final long sendRTA;

    public TimerStartPacket(InGameTimer timer, long rta) {
        super(IDENTIFIER);
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<Integer> keyInt = timer.getMoreDataKeys();
        while (keyInt.hasMoreElements()) {
            Integer key = keyInt.nextElement();
            Integer value = timer.getMoreData(key);
            stringBuilder.append(key).append(",").append(value).append(";");
        }
        this.timerUuid = timer.getUuid();
        this.category = timer.getCategory();
        this.runType = timer.getRunType();
        this.customData = stringBuilder.substring(0, stringBuilder.length() - (stringBuilder.length() > 0 ? 1 : 0));
        this.sendRTA = rta;
    }

    public TimerStartPacket(class_9129 buf) {
        super(IDENTIFIER);
        this.timerUuid = buf.method_10790();
        this.category = RunCategory.getCategory(buf.method_19772());
        this.runType = RunType.fromInt(buf.readInt());
        this.customData = buf.method_19772();
        this.sendRTA = buf.readLong();
    }

    @Override
    protected void write(class_9129 buf) {
        buf.method_10797(this.timerUuid);
        buf.method_10814(this.category.getID());
        buf.method_53002(this.runType.getCode());
        buf.method_10814(this.customData);
        buf.method_52974(this.sendRTA);
    }

    @Override
    public void receiveClient2ServerPacket(MinecraftServer server) {
        if (!SpeedRunIGT.IS_CLIENT_SIDE) {
            this.timerInit(true);
        }
        this.sendPacketToPlayers(server);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void receiveServer2ClientPacket(class_310 client) {
        this.timerInit(client.method_1496());
    }

    public void timerInit(boolean isIntegrated) {
        long startTime = System.currentTimeMillis() - this.sendRTA;
        if (!SpeedRunIGT.IS_CLIENT_SIDE || !Objects.equals(InGameTimer.getInstance().getUuid().toString(), this.timerUuid.toString())) {
            InGameTimer.start("", this.runType);
            InGameTimer.getInstance().setStartTime(startTime);
            InGameTimer.getInstance().setCategory(this.category, false);
        }
        InGameTimer.getInstance().setCoop(true);
        InGameTimer.getInstance().setServerIntegrated(isIntegrated);
        if (!this.customData.isEmpty()) {
            for (String customString : this.customData.split(";")) {
                String[] data = customString.split(",");
                int key = Integer.parseInt(data[0]);
                int value = Integer.parseInt(data[1]);
                InGameTimer.getInstance().updateMoreData(key, value);
            }
        }
    }
}

