/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.utils;

import com.mojang.blaze3d.platform.TextureUtil;
import com.redlimerl.speedrunigt.SpeedRunIGT;
import com.redlimerl.speedrunigt.utils.FontConfigure;
import com.redlimerl.speedrunigt.utils.FontIdentifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2960;
import net.minecraft.class_376;
import net.minecraft.class_390;
import net.minecraft.class_395;
import net.minecraft.class_9111;
import org.apache.commons.io.FileUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.freetype.FT_Face;
import org.lwjgl.util.freetype.FreeType;

public class FontUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFont(HashMap<class_2960, List<class_390>> map, File file, File configFile) {
        FileInputStream fileInputStream = null;
        FT_Face fT_Face = null;
        ByteBuffer byteBuffer = null;
        IOException throwable = null;
        try {
            fileInputStream = new FileInputStream(file);
            byteBuffer = TextureUtil.readResource((InputStream)fileInputStream);
            byteBuffer.flip();
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
                class_9111.method_56145((int)FreeType.FT_New_Memory_Face((long)class_9111.method_56143(), (ByteBuffer)byteBuffer, (long)0L, (PointerBuffer)pointerBuffer), (String)"Initializing font face");
                fT_Face = FT_Face.create((long)pointerBuffer.get());
            }
            String string = FreeType.FT_Get_Font_Format((FT_Face)fT_Face);
            if (!"TrueType".equals(string)) {
                throw new IOException("Font is not in TTF format, was " + string);
            }
            class_9111.method_56145((int)FreeType.FT_Select_Charmap((FT_Face)fT_Face, (int)FreeType.FT_ENCODING_UNICODE), (String)"Find unicode charmap");
            class_2960 fontIdentifier = class_2960.method_60655((String)"speedrunigt", (String)file.getName().toLowerCase(Locale.ROOT).replace(".ttf", "").replaceAll(" ", "_").replaceAll("[^a-z0-9/._-]", ""));
            ArrayList<Object> fontArrayList = new ArrayList<Object>();
            FontConfigure fontConfigure = configFile != null && configFile.exists() ? FontConfigure.fromJson(FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8)) : FontConfigure.create();
            fontArrayList.add(new class_395(byteBuffer, fT_Face, fontConfigure.size, fontConfigure.oversample, fontConfigure.shift[0], fontConfigure.shift[1], fontConfigure.skip));
            SpeedRunIGT.FONT_MAPS.put(fontIdentifier, new FontIdentifier(file, fontIdentifier, fontConfigure));
            fontArrayList.add(new class_376());
            map.put(fontIdentifier, fontArrayList);
        }
        catch (FileNotFoundException e) {
            if (fT_Face != null) {
                fT_Face.free();
            }
            MemoryUtil.memFree(byteBuffer);
        }
        catch (IOException throwable1) {
            throwable = throwable1;
        }
        finally {
            block26: {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    if (throwable == null) break block26;
                    throwable.addSuppressed(e);
                }
            }
        }
    }

    public static void copyDefaultFonts() {
        FontUtils.copyResourceToFont("calibri_bold.ttf");
        FontUtils.copyResourceToFont("calibri_bold.json");
    }

    private static void copyResourceToFont(String fileName) {
        File fontFile = SpeedRunIGT.FONT_PATH.resolve(fileName).toFile();
        if (!fontFile.exists()) {
            InputStream fontInput = FontUtils.class.getResourceAsStream("/font/" + fileName);
            if (fontInput == null) {
                return;
            }
            try {
                int readData;
                FileOutputStream output = new FileOutputStream(fontFile);
                byte[] buf = new byte[1024];
                while ((readData = fontInput.read(buf)) > 0) {
                    output.write(buf, 0, readData);
                }
                fontInput.close();
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

