/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.speedrunigt.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_2477;
import net.minecraft.class_310;

public class TranslateHelper {
    public static String[] getLangFileNames() throws IOException, URISyntaxException {
        ArrayList list;
        block3: {
            block2: {
                ZipEntry e;
                String path = "assets/speedrunigt/lang";
                File jarFile = new File(TranslateHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                list = Lists.newArrayList();
                if (!jarFile.isFile()) break block2;
                ZipInputStream zip = new ZipInputStream(TranslateHelper.class.getProtectionDomain().getCodeSource().getLocation().openStream());
                while ((e = zip.getNextEntry()) != null) {
                    String[] fileName;
                    String file;
                    String name = e.getName();
                    if (!name.startsWith("assets/speedrunigt/lang") || (file = (fileName = name.split("/"))[fileName.length - 1]).isEmpty() || fileName.length <= 1) continue;
                    list.add("/assets/speedrunigt/lang/" + file);
                }
                break block3;
            }
            URL url = TranslateHelper.class.getResource("/assets/speedrunigt/lang");
            if (url == null) break block3;
            File apps = new File(url.toURI());
            for (File app : Objects.requireNonNull(apps.listFiles())) {
                list.add("/assets/speedrunigt/lang/" + app.getName());
            }
        }
        return list.toArray(new String[0]);
    }

    public static void setup(String langCode, BiConsumer<String, String> biConsumer, boolean englishOnly) {
        try {
            for (String langFileName : TranslateHelper.getLangFileNames()) {
                InputStream inputStream;
                if (englishOnly && !langFileName.endsWith("en_us.json") || !langFileName.endsWith(langCode + ".json") || (inputStream = TranslateHelper.class.getResourceAsStream(langFileName)) == null) continue;
                class_2477.method_29425((InputStream)inputStream, biConsumer);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        class_310.method_1551().method_1521();
    }
}

