/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy;

import com.snackpirate.aeromancy.data.AAEntityTypeTags;
import com.snackpirate.aeromancy.spells.AASpells;
import com.snackpirate.aeromancy.spells.summon_breeze.SummonedBreeze;
import com.snackpirate.aeromancy.spells.wind_shield.WindShieldSpell;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber(modid="aero_additions", bus=EventBusSubscriber.Bus.MOD)
public class AAServerEvents {
    @SubscribeEvent
    public static void addAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, AASpells.Attributes.WIND_SPELL_POWER);
        event.add(EntityType.PLAYER, AASpells.Attributes.WIND_MAGIC_RESIST);
    }

    @SubscribeEvent
    public static void onAttributeCreate(EntityAttributeCreationEvent event) {
        event.put((EntityType)AASpells.Entities.SUMMONED_BREEZE.get(), SummonedBreeze.createAttributes().build());
    }

    @EventBusSubscriber(modid="aero_additions", bus=EventBusSubscriber.Bus.GAME)
    public static class Game {
        @SubscribeEvent
        public static void windShieldDeflection(ProjectileImpactEvent event) {
            LivingEntity entity;
            EntityHitResult result;
            HitResult hitResult = event.getRayTraceResult();
            if (hitResult instanceof EntityHitResult && (hitResult = (result = (EntityHitResult)hitResult).getEntity()) instanceof LivingEntity && (entity = (LivingEntity)hitResult).hasEffect(AASpells.MobEffects.WIND_SHIELD) && !event.getProjectile().getType().is(AAEntityTypeTags.REFLECTION_IMMUNE) && entity.getRandom().nextFloat() < WindShieldSpell.chanceToDeflect(entity.getEffect(AASpells.MobEffects.WIND_SHIELD).getAmplifier())) {
                event.setCanceled(true);
                entity.level().playSound(null, (Entity)entity, SoundEvents.BREEZE_DEFLECT, entity.getSoundSource(), 1.0f, 1.0f);
                event.getProjectile().deflect(ProjectileDeflection.REVERSE, (Entity)entity, (Entity)entity, entity instanceof Player);
            }
        }
    }
}

