/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.data;

import com.snackpirate.aeromancy.item.AAItems;
import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class AALang
extends LanguageProvider {
    public AALang(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    public AALang(PackOutput p) {
        this(p, "aero_additions", "en_us");
    }

    protected void addTranslations() {
        this.addSpell(AASpells.WIND_CHARGE.get(), "Wind Charge", "Fire a powerful wind charge, which launches enemies on impact.");
        this.addSchool(AASpells.Schools.WIND.get(), "Wind");
        this.add("ui.aero_additions.stun_duration", "%ss Stun Duration");
        this.add("ui.aero_additions.recast_targets", "%s Targets");
        this.addSpell(AASpells.UPDRAFT.get(), "Updraft", "Launch enemies into the air, temporarily stunning them.");
        this.addSpell(AASpells.AIRSTEP.get(), "Airstep", "Execute a series of mid-air jumps, in rapid succession.");
        this.add("spell.aero_additions.airstep.max_jumps", "%s Jumps");
        this.addSpell(AASpells.ASPHYXIATE.get(), "Asphyxiate", "Draw the air out of the target's lungs, slowly killing them.");
        this.addSpell(AASpells.FEATHER_FALL.get(), "Feather Fall", "Give you and your nearby allies the Slow Falling effect.");
        this.addItem((Supplier)AAItems.AIR_STAFF, "Air Staff");
        this.addItem((Supplier)AAItems.UPDRAFT_TOME, "Updraft Tome");
        this.add(((Item)AAItems.UPDRAFT_TOME.get()).getDescriptionId() + ".guide", "Can be obtained from Ominous Vaults in Trial Chambers.");
        this.add("attribute.aero_additions.wind_spell_power", "Wind Spell Power");
        this.add("attribute.aero_additions.wind_magic_resist", "Wind Spell Resistance");
        this.addItem((Supplier)AAItems.WIND_RUNE, "Wind Rune");
        this.addItem((Supplier)AAItems.WIND_UPGRADE_ORB, "Wind Upgrade Orb");
        this.addItem((Supplier)AAItems.WINDMAKER_HEADPIECE, "Windmaker Headpiece");
        this.addItem((Supplier)AAItems.WINDMAKER_ROBES, "Windmaker Robes");
        this.addItem((Supplier)AAItems.WINDMAKER_SKIRT, "Windmaker Leggings");
        this.addItem((Supplier)AAItems.WINDMAKER_BOOTS, "Windmaker Boots");
        this.add("death.attack.asphyxiation", "%s discovered that air is essential to life");
        this.addEffect((Supplier)AASpells.MobEffects.BREATHLESS, "Breathless");
        this.addEffect((Supplier)AASpells.MobEffects.WIND_SHIELD, "Wind Shielded");
        this.addSpell(AASpells.WIND_SHIELD.get(), "Wind Shield", "Form a swirling shield of air around your body, reflecting any projectile coming your way.");
        this.add("spell.aero_additions.wind_shield.chance", "%s%% Chance To Deflect Projectiles");
        this.add("itemGroup.aero_additions.main_tab", "Aeromancy Additions");
        this.add("material.aero_additions.rune_wind", "Wind Rune");
        this.addSpell(AASpells.AIRBLAST.get(), "Airblast", "Quickly fire a small gust of air, capable of reflecting projectiles. Mmmph mmmph!");
        this.add("spell.aero_additions.airblast.max_range", "%s Block Range");
        this.add("spell.aero_additions.airblast.deflection_power", "%s%% Reflection Power");
        this.add("spell.aero_additions.airblast.degree_width", "%s\u00b0 Arc");
        this.addItem((Supplier)AAItems.WIND_SWORD, "Tempest Blade");
        this.addEntityType((Supplier)AASpells.Entities.WIND_BLADE_PROJECTILE, "Wind Blade");
        this.add("death.attack.aero_additions.wind_blade", "%1$s was struck down by %2$s's Wind Blade");
        this.addEntityType((Supplier)AASpells.Entities.MAGIC_WIND_CHARGE, "Magic Wind Charge");
        this.addEntityType((Supplier)AASpells.Entities.UPDRAFT_VISUAL_ENTITY, "Gust");
        this.addEntityType((Supplier)AASpells.Entities.SUMMONED_BREEZE, "Summoned Breeze");
        this.addSpell(AASpells.WIND_BLADE.get(), "Wind Blade", "Conjure a swiftly-moving blade of pure, swirling wind, dealing low damage but high knockback upon impact.");
        this.addSpell(AASpells.FLUSH.get(), "Flush", "Expel a large quantity of water around you.");
        this.addSpell(AASpells.DASH.get(), "Dash", "Quickly dash forward.");
    }

    public void addSpell(AbstractSpell spell, String name, String guide) {
        this.add("spell.aero_additions." + spell.getSpellResource().getPath(), name);
        this.add("spell.aero_additions." + spell.getSpellResource().getPath() + ".guide", guide);
    }

    public void addSchool(SchoolType school, String name) {
        this.add("school.aero_additions." + school.getId().getPath(), name);
    }
}

