/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells;

import com.snackpirate.aeromancy.AASounds;
import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.data.AADamageTypes;
import com.snackpirate.aeromancy.data.AAItemTags;
import com.snackpirate.aeromancy.spells.airblast.AirblastSpell;
import com.snackpirate.aeromancy.spells.airstep.AirstepSpell;
import com.snackpirate.aeromancy.spells.asphyxiate.AsphyxiateSpell;
import com.snackpirate.aeromancy.spells.asphyxiate.BreathlessEffect;
import com.snackpirate.aeromancy.spells.dash.DashSpell;
import com.snackpirate.aeromancy.spells.feather_fall.FeatherFallSpell;
import com.snackpirate.aeromancy.spells.flush.FlushSpell;
import com.snackpirate.aeromancy.spells.summon_breeze.SummonedBreeze;
import com.snackpirate.aeromancy.spells.tornado.TornadoEntity;
import com.snackpirate.aeromancy.spells.tornado.TornadoSpell;
import com.snackpirate.aeromancy.spells.updraft.UpdraftEntity;
import com.snackpirate.aeromancy.spells.updraft.UpdraftSpell;
import com.snackpirate.aeromancy.spells.wind_blade.WindBladeProjectile;
import com.snackpirate.aeromancy.spells.wind_blade.WindBladeSpell;
import com.snackpirate.aeromancy.spells.wind_charge.MagicWindCharge;
import com.snackpirate.aeromancy.spells.wind_charge.WindChargeSpell;
import com.snackpirate.aeromancy.spells.wind_shield.WindShieldEffect;
import com.snackpirate.aeromancy.spells.wind_shield.WindShieldSpell;
import io.redspace.ironsspellbooks.api.attribute.MagicRangedAttribute;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AASpells {
    private static final DeferredRegister<AbstractSpell> SPELLS = DeferredRegister.create((ResourceKey)SpellRegistry.SPELL_REGISTRY_KEY, (String)"aero_additions");
    public static final Supplier<AbstractSpell> WIND_CHARGE = AASpells.registerSpell(new WindChargeSpell());
    public static final Supplier<AbstractSpell> UPDRAFT = AASpells.registerSpell(new UpdraftSpell());
    public static final Supplier<AbstractSpell> AIRSTEP = AASpells.registerSpell(new AirstepSpell());
    public static final Supplier<AbstractSpell> ASPHYXIATE = AASpells.registerSpell(new AsphyxiateSpell());
    public static final Supplier<AbstractSpell> FEATHER_FALL = AASpells.registerSpell(new FeatherFallSpell());
    public static final Supplier<AbstractSpell> WIND_SHIELD = AASpells.registerSpell(new WindShieldSpell());
    public static final Supplier<AbstractSpell> AIRBLAST = AASpells.registerSpell(new AirblastSpell());
    public static final Supplier<AbstractSpell> WIND_BLADE = AASpells.registerSpell(new WindBladeSpell());
    public static final Supplier<AbstractSpell> FLUSH = AASpells.registerSpell(new FlushSpell());
    public static final Supplier<AbstractSpell> DASH = AASpells.registerSpell(new DashSpell());
    public static final Supplier<AbstractSpell> TORNADO = AASpells.registerSpell(new TornadoSpell());

    private static Supplier<AbstractSpell> registerSpell(AbstractSpell spell) {
        return SPELLS.register(spell.getSpellName(), () -> spell);
    }

    public static void register(IEventBus eventBus) {
        SPELLS.register(eventBus);
        Entities.ENTITIES.register(eventBus);
        Schools.SCHOOLS.register(eventBus);
        Attributes.ATTRIBUTES.register(eventBus);
        MobEffects.MOB_EFFECTS.register(eventBus);
    }

    public static class Entities {
        private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"aero_additions");
        private static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"aero_additions");
        public static final DeferredHolder<EntityType<?>, EntityType<MagicWindCharge>> MAGIC_WIND_CHARGE = ENTITIES.register("magic_wind_charge", () -> EntityType.Builder.of(MagicWindCharge::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(64).build(Aeromancy.id("magic_wind_charge").toString()));
        public static final DeferredHolder<EntityType<?>, EntityType<UpdraftEntity>> UPDRAFT_VISUAL_ENTITY = ENTITIES.register("updraft_visual", () -> EntityType.Builder.of(UpdraftEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(64).build(Aeromancy.id("updraft_visual").toString()));
        public static final DeferredHolder<EntityType<?>, EntityType<SummonedBreeze>> SUMMONED_BREEZE = ENTITIES.register("summoned_breeze", () -> EntityType.Builder.of(SummonedBreeze::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.77f).clientTrackingRange(64).build(Aeromancy.id("summoned_breeze").toString()));
        public static final DeferredHolder<EntityType<?>, EntityType<WindBladeProjectile>> WIND_BLADE_PROJECTILE = ENTITIES.register("wind_blade", () -> EntityType.Builder.of(WindBladeProjectile::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(64).build(Aeromancy.id("wind_blade").toString()));
        public static final DeferredHolder<EntityType<?>, EntityType<TornadoEntity>> TORNADO = ENTITIES.register("tornado", () -> EntityType.Builder.of(TornadoEntity::new, (MobCategory)MobCategory.MISC).sized(10.0f, 6.0f).clientTrackingRange(64).build(Aeromancy.id("tornado").toString()));
    }

    public static class Schools {
        public static final ResourceLocation WIND_RESOURCE = Aeromancy.id("wind");
        private static final DeferredRegister<SchoolType> SCHOOLS = DeferredRegister.create((ResourceKey)SchoolRegistry.SCHOOL_REGISTRY_KEY, (String)"aero_additions");
        public static final Supplier<SchoolType> WIND = Schools.registerSchool(new SchoolType(WIND_RESOURCE, AAItemTags.WIND_FOCUS, (Component)Component.translatable((String)"school.aero_additions.wind").withColor(10729215), Attributes.WIND_SPELL_POWER, Attributes.WIND_MAGIC_RESIST, AASounds.WIND_CAST, AADamageTypes.WIND_MAGIC));

        private static Supplier<SchoolType> registerSchool(SchoolType schoolType) {
            return SCHOOLS.register(schoolType.getId().getPath(), () -> schoolType);
        }
    }

    public static class Attributes {
        private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"aero_additions");
        public static final DeferredHolder<Attribute, Attribute> WIND_MAGIC_RESIST = Attributes.newResistanceAttribute("wind");
        public static final DeferredHolder<Attribute, Attribute> WIND_SPELL_POWER = Attributes.newPowerAttribute("wind");

        private static DeferredHolder<Attribute, Attribute> newResistanceAttribute(String id) {
            return ATTRIBUTES.register(id + "_magic_resist", () -> new MagicRangedAttribute("attribute.aero_additions." + id + "_magic_resist", 1.0, -100.0, 100.0).setSyncable(true));
        }

        private static DeferredHolder<Attribute, Attribute> newPowerAttribute(String id) {
            return ATTRIBUTES.register(id + "_spell_power", () -> new MagicRangedAttribute("attribute.aero_additions." + id + "_spell_power", 1.0, -100.0, 100.0).setSyncable(true));
        }
    }

    public static class MobEffects {
        public static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"aero_additions");
        public static final DeferredHolder<MobEffect, MobEffect> WIND_SHIELD = MOB_EFFECTS.register("wind_shield", () -> new WindShieldEffect(MobEffectCategory.BENEFICIAL, 13888490));
        public static final DeferredHolder<MobEffect, MobEffect> BREATHLESS = MOB_EFFECTS.register("breathless", () -> new BreathlessEffect(MobEffectCategory.HARMFUL, 13888490).addAttributeModifier(net.minecraft.world.entity.ai.attributes.Attributes.MOVEMENT_SPEED, Aeromancy.id("breathless_slow"), -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(net.minecraft.world.entity.ai.attributes.Attributes.ATTACK_DAMAGE, Aeromancy.id("breathless_weak"), (double)-0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        public static final DeferredHolder<MobEffect, SummonTimer> BREEZE_TIMER = MOB_EFFECTS.register("breeze_timer", () -> new SummonTimer(MobEffectCategory.BENEFICIAL, 12495141));
    }
}

