/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.airstep;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class AirstepSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(AASpells.Schools.WIND_RESOURCE).setMaxLevel(7).setCooldownSeconds(6.0).build();

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("airstep");
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"spell.aero_additions.airstep.max_jumps", (Object[])new Object[]{spellLevel}));
    }

    public AirstepSpell() {
        this.manaCostPerLevel = 7;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 40;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public SchoolType getSchoolType() {
        return AASpells.Schools.WIND.get();
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 1 + spellLevel;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return !entity.isFallFlying() && !entity.isInWaterOrBubble();
    }

    public void onClientCast(Level level, int spellLevel, LivingEntity entity, ICastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData data = (ImpulseCastData)castData;
            entity.hasImpulse = data.hasImpulse;
            double y = Math.max(entity.getDeltaMovement().y, (double)data.y);
            entity.setDeltaMovement((double)data.x, y, (double)data.z);
        }
        super.onClientCast(level, spellLevel, entity, castData);
    }

    public ICastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 80, castSource, null), playerMagicData);
        }
        Vec3 motion = new Vec3(0.0, entity.getAttributeValue(Attributes.JUMP_STRENGTH) + (double)entity.getJumpBoostPower() + 0.02 * (double)this.getSpellPower(spellLevel, (Entity)entity), 0.0);
        Vec3 angle = entity.getLookAngle();
        motion = angle.scale(Mth.invSqrt((double)(angle.x * angle.x + angle.z * angle.z + (double)0.01f))).multiply(0.45 + 0.02 * (double)this.getSpellPower(spellLevel, (Entity)entity), 0.0, 0.45 + 0.02 * (double)this.getSpellPower(spellLevel, (Entity)entity)).add(motion);
        playerMagicData.setAdditionalCastData((ICastData)new ImpulseCastData((float)motion.x, (float)motion.y, (float)motion.z, true));
        entity.setDeltaMovement(motion);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.SPIT, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (int)10, (double)0.2, (double)0.0, (double)0.2, (double)0.3, (boolean)true);
        entity.hasImpulse = true;
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.TOUCH_GROUND_ANIMATION;
    }
}

