/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.dash;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.AASpells;
import com.snackpirate.aeromancy.spells.dash.DashParticlesPacket;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

@AutoSpellConfig
public class DashSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(AASpells.Schools.WIND_RESOURCE).setMaxLevel(5).setCooldownSeconds(2.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.strength", (Object[])new Object[]{String.format("%s%%", (int)((15.0f + this.getSpellPower(spellLevel, (Entity)caster)) / 12.0f * 100.0f / 2.08f))}));
    }

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("dash");
    }

    public DashSpell() {
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.baseManaCost = 20;
        this.manaCostPerLevel = 2;
        this.castTime = 0;
    }

    public void onClientCast(Level level, int spellLevel, LivingEntity entity, ICastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData bdcd = (ImpulseCastData)castData;
            entity.hasImpulse = bdcd.hasImpulse;
            entity.setDeltaMovement(entity.getDeltaMovement().add((double)bdcd.x, (double)bdcd.y, (double)bdcd.z));
        }
        super.onClientCast(level, spellLevel, entity, castData);
    }

    public ICastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.hasImpulse = true;
        float multiplier = (15.0f + this.getSpellPower(spellLevel, (Entity)entity)) / 12.0f;
        Vec3 forward = entity.getLookAngle();
        Vec3 vec = forward.multiply(2.0, 1.0, 2.0).normalize().scale((double)multiplier);
        if (entity.onGround()) {
            entity.setPos(entity.position().add(0.0, 1.5, 0.0));
            vec.add(0.0, 0.25, 0.0);
        }
        playerMagicData.setAdditionalCastData((ICastData)new ImpulseCastData((float)vec.x, (float)vec.y, (float)vec.z, true));
        entity.setDeltaMovement(new Vec3(Mth.lerp((double)0.75, (double)entity.getDeltaMovement().x, (double)vec.x), Mth.lerp((double)0.75, (double)entity.getDeltaMovement().y, (double)vec.y), Mth.lerp((double)0.75, (double)entity.getDeltaMovement().z, (double)vec.z)));
        if (entity instanceof Player) {
            Player p = (Player)entity;
            p.setIgnoreFallDamageFromCurrentImpulse(true);
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new DashParticlesPacket(entity.position(), vec), (CustomPacketPayload[])new CustomPacketPayload[0]);
        entity.invulnerableTime = 20;
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SELF_CAST_ANIMATION;
    }
}

