/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.feather_fall;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.spells.TargetedTargetAreaCastData;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class FeatherFallSpell
extends AbstractSpell {
    private static final int MAX_TARGETS = 5;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(AASpells.Schools.WIND_RESOURCE).setMaxLevel(6).setCooldownSeconds(45.0).build();

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("feather_fall");
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel, caster), (int)1)}), Component.translatable((String)"ui.irons_spellbooks.max_victims", (Object[])new Object[]{5}));
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public FeatherFallSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 30;
        this.spellPowerPerLevel = 5;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (!Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.35f, (boolean)false)) {
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(entity));
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.irons_spellbooks.spell_target_success_self", (Object[])new Object[]{this.getDisplayName((Player)serverPlayer)}).withStyle(ChatFormatting.GREEN)));
            }
        }
        float radius = 3.0f;
        LivingEntity target = ((TargetEntityCastData)playerMagicData.getAdditionalCastData()).getTarget((ServerLevel)level);
        TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)level, (Vec3)target.position(), (float)radius, (int)Utils.packRGB((Vector3f)this.getTargetingColor()), (Entity)target);
        playerMagicData.setAdditionalCastData((ICastData)new TargetedTargetAreaCastData(target, area));
        return true;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetedTargetAreaCastData targetData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetedTargetAreaCastData && (targetEntity = (targetData = (TargetedTargetAreaCastData)iCastData).getTarget((ServerLevel)world)) != null) {
            float radius = 3.0f;
            AtomicInteger targets = new AtomicInteger(0);
            targetEntity.level().getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate((double)radius)).forEach(victim -> {
                if (targets.get() < 5 && victim.distanceToSqr((Entity)targetEntity) < (double)(radius * radius) && Utils.shouldHealEntity((LivingEntity)entity, (LivingEntity)victim)) {
                    victim.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, this.getDuration(spellLevel, entity), 0));
                    targets.incrementAndGet();
                }
            });
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
    }
}

