/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.summon_breeze;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.summon_breeze.SummonedBreeze;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import java.util.EnumSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class BreezeBrainGoals {

    public static class CopyOwnerTarget
    extends TargetGoal {
        private final Supplier<LivingEntity> ownerGetter;

        public CopyOwnerTarget(PathfinderMob pMob, Supplier<LivingEntity> ownerGetter) {
            super((Mob)pMob, false);
            this.ownerGetter = ownerGetter;
        }

        public boolean canUse() {
            IMagicSummon summon;
            Mob owner;
            LivingEntity livingEntity = this.ownerGetter.get();
            return livingEntity instanceof Mob && (owner = (Mob)livingEntity).getTarget() != null && (!((livingEntity = owner.getTarget()) instanceof IMagicSummon) || (summon = (IMagicSummon)livingEntity).getSummoner() != owner);
        }

        public void start() {
            LivingEntity target = ((Mob)this.ownerGetter.get()).getTarget();
            this.mob.setTarget(target);
            this.mob.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)target, 200L);
            super.start();
        }
    }

    public static class OwnerHurtTarget
    extends TargetGoal {
        private final SummonedBreeze entity;
        private final Supplier<LivingEntity> owner;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public OwnerHurtTarget(SummonedBreeze entity, Supplier<LivingEntity> ownerGetter) {
            super((Mob)entity, false);
            this.entity = entity;
            this.owner = ownerGetter;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            IMagicSummon summon;
            LivingEntity livingEntity;
            LivingEntity owner = this.owner.get();
            if (owner == null) {
                return false;
            }
            this.ownerLastHurt = owner.getLastHurtMob();
            int i = owner.getLastHurtMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.DEFAULT) && (!((livingEntity = this.ownerLastHurt) instanceof IMagicSummon) || (summon = (IMagicSummon)livingEntity).getSummoner() != owner);
        }

        public void start() {
            this.mob.setTarget(this.ownerLastHurt);
            Aeromancy.LOGGER.debug("GenericOwnerHurtTargetGoal.start");
            Aeromancy.LOGGER.debug("Brain before: {}", (Object)this.mob.getBrain().getMemories().keySet().stream().map(key -> String.valueOf(key) + "=" + String.valueOf(this.mob.getBrain().getMemories().get(key))).collect(Collectors.joining(", ", "{", "}")));
            this.mob.getBrain().setMemoryWithExpiry(MemoryModuleType.NEAREST_ATTACKABLE, (Object)this.ownerLastHurt, 200L);
            Aeromancy.LOGGER.debug("Brain After: {}", (Object)this.mob.getBrain().getMemories().keySet().stream().map(key -> String.valueOf(key) + "=" + String.valueOf(this.mob.getBrain().getMemories().get(key))).collect(Collectors.joining(", ", "{", "}")));
            LivingEntity owner = this.owner.get();
            if (owner != null) {
                this.timestamp = owner.getLastHurtMobTimestamp();
            }
            super.start();
        }
    }

    public static class OwnerHurtByTarget
    extends TargetGoal {
        private final SummonedBreeze entity;
        private final Supplier<LivingEntity> owner;
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public OwnerHurtByTarget(SummonedBreeze entity, Supplier<LivingEntity> getOwner) {
            super((Mob)entity, false);
            this.entity = entity;
            this.owner = getOwner;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            IMagicSummon summon;
            LivingEntity livingEntity;
            LivingEntity owner = this.owner.get();
            if (owner == null) {
                return false;
            }
            this.ownerLastHurtBy = owner.getLastHurtByMob();
            if (this.ownerLastHurtBy == null || this.ownerLastHurtBy.isAlliedTo((Entity)this.mob)) {
                return false;
            }
            int i = owner.getLastHurtByMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && (!((livingEntity = this.ownerLastHurtBy) instanceof IMagicSummon) || (summon = (IMagicSummon)livingEntity).getSummoner() != owner);
        }

        public void start() {
            this.mob.setTarget(this.ownerLastHurtBy);
            this.mob.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)this.ownerLastHurtBy, 200L);
            LivingEntity owner = this.owner.get();
            if (owner != null) {
                this.timestamp = owner.getLastHurtByMobTimestamp();
            }
            super.start();
        }
    }
}

