/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.summon_breeze;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.AASpells;
import com.snackpirate.aeromancy.spells.summon_breeze.SummonedBreeze;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@AutoSpellConfig
public class SummonBreezeSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(AASpells.Schools.WIND_RESOURCE).setMaxLevel(5).setCooldownSeconds(180.0).build();

    public SummonBreezeSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("summon_breeze");
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 12000;
        SummonedBreeze breeze = new SummonedBreeze(world, entity);
        breeze.setPos(entity.position());
        breeze.getAttributes().getInstance(Attributes.MAX_HEALTH).setBaseValue(20.0);
        breeze.setHealth(breeze.getMaxHealth());
        SpellSummonEvent event = (SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(entity, (LivingEntity)breeze, this.getSpellResource(), spellLevel));
        world.addFreshEntity((Entity)event.getCreature());
        breeze.addEffect(new MobEffectInstance(AASpells.MobEffects.BREEZE_TIMER, summonTime, 0, false, false, false));
        int effectAmplifier = 0;
        if (entity.hasEffect(AASpells.MobEffects.BREEZE_TIMER)) {
            effectAmplifier += entity.getEffect(AASpells.MobEffects.BREEZE_TIMER).getAmplifier() + 1;
        }
        entity.addEffect(new MobEffectInstance(AASpells.MobEffects.BREEZE_TIMER, summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }
}

