/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.tornado;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.tornado.TornadoEntity;
import com.snackpirate.aeromancy.spells.tornado.TornadoModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.specialty.DynamicGeoEntityRenderer;
import software.bernie.geckolib.util.Color;

public class TornadoRenderer
extends DynamicGeoEntityRenderer<TornadoEntity> {
    public TornadoRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new TornadoModel());
    }

    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, TornadoEntity animatable, float partialTick) {
        return !bone.getName().contains("top") ? Aeromancy.id("textures/entity/tornado.png") : Aeromancy.id("textures/entity/tornado_top.png");
    }

    @Nullable
    public RenderType getRenderType(TornadoEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        float f = (float)animatable.tickCount + partialTick;
        return RenderType.breezeWind((ResourceLocation)texture, (float)(this.xOffset(f) % 1.0f), (float)0.0f);
    }

    @Nullable
    protected RenderType getRenderTypeOverrideForBone(GeoBone bone, TornadoEntity animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        float f = (float)animatable.tickCount + partialTick;
        return RenderType.breezeWind((ResourceLocation)texturePath, (float)(!bone.getName().contains("top") ? this.xOffset(f) % 1.0f : 0.0f), (float)0.0f);
    }

    public Color getRenderColor(TornadoEntity animatable, float partialTick, int packedLight) {
        int colorValue = switch (animatable.getEffect()) {
            default -> throw new MatchException(null, null);
            case TornadoEntity.TornadoEffect.DEFAULT -> 0xFFFFFF;
            case TornadoEntity.TornadoEffect.FIRE -> 16753920;
            case TornadoEntity.TornadoEffect.ENDER -> 0xFF00FF;
            case TornadoEntity.TornadoEffect.NATURE -> 65280;
            case TornadoEntity.TornadoEffect.LIGHTNING -> 65535;
            case TornadoEntity.TornadoEffect.ICE -> 0x50FFFF;
        };
        return new Color(-805306368 + colorValue);
    }

    private float xOffset(float tickCount) {
        return tickCount * 0.02f;
    }

    public void preRender(PoseStack poseStack, TornadoEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.scale(animatable.getSize() / 6.5f, animatable.getSize() / 6.5f, animatable.getSize() / 6.5f);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }
}

