/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.wind_blade;

import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class WindBladeProjectile
extends AbstractMagicProjectile {
    public void trailParticles() {
        for (int i = 0; i < 1; ++i) {
            double speed = 0.05;
            double dx = Utils.random.nextDouble() * 2.0 * speed - speed;
            double dy = Utils.random.nextDouble() * 2.0 * speed - speed;
            double dz = Utils.random.nextDouble() * 2.0 * speed - speed;
            this.level().addParticle((ParticleOptions)(Utils.random.nextDouble() < 0.3 ? ParticleTypes.SPIT : ParticleTypes.POOF), this.getX() + dx, this.getY() + dy, this.getZ() + dz, dx, dy, dz);
        }
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.SPIT, (double)x, (double)y, (double)z, (int)5, (double)0.1, (double)0.1, (double)0.1, (double)0.25, (boolean)true);
    }

    public float getSpeed() {
        return 1.75f;
    }

    public WindBladeProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)AASpells.Entities.WIND_BLADE_PROJECTILE.get()), levelIn);
        this.setOwner((Entity)shooter);
    }

    public Optional<Holder<SoundEvent>> getImpactSound() {
        return Optional.of(SoundEvents.WIND_CHARGE_BURST);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity target = entityHitResult.getEntity();
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.knockback((double)this.getDamage(), this.getX() - target.getX(), this.getZ() - target.getZ());
        }
        DamageSources.applyDamage((Entity)target, (float)this.getDamage(), (DamageSource)AASpells.WIND_BLADE.get().getDamageSource((Entity)this, this.getOwner()));
        this.discard();
    }

    public WindBladeProjectile(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

