/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.wind_charge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.snackpirate.aeromancy.spells.wind_charge.MagicWindCharge;
import com.snackpirate.aeromancy.spells.wind_charge.MagicWindChargeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class MagicWindChargeRenderer
extends EntityRenderer<MagicWindCharge> {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = Mth.square((float)3.5f);
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/projectiles/wind_charge.png");
    private final MagicWindChargeModel model;

    public MagicWindChargeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MagicWindChargeModel(context.bakeLayer(ModelLayers.WIND_CHARGE));
    }

    public void render(MagicWindCharge entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)entity) < (double)MIN_CAMERA_DISTANCE_SQUARED)) {
            float f = (float)entity.tickCount + partialTick;
            VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.breezeWind((ResourceLocation)TEXTURE_LOCATION, (float)(this.xOffset(entity, f) % 1.0f), (float)0.0f));
            this.model.setupAnim(entity, 0.0f, 0.0f, f, 0.0f, 0.0f);
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    protected float xOffset(MagicWindCharge entity, float tickCount) {
        return tickCount * 0.03f * entity.getDamage() * 1.2f;
    }

    public ResourceLocation getTextureLocation(MagicWindCharge magicWindCharge) {
        return TEXTURE_LOCATION;
    }
}

