/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.wind_shield;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.snackpirate.aeromancy.Aeromancy;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

@OnlyIn(value=Dist.CLIENT)
public class WindySwirlRenderer {
    private static final int COLOR = RenderHelper.colorf((float)0.5f, (float)0.5f, (float)0.5f);
    public static final long RENDER_ASPHYXIATION = 512L;

    private static RenderType getRenderType(ResourceLocation texture, float f) {
        return RenderType.energySwirl((ResourceLocation)texture, (float)(f * 0.02f % 1.0f), (float)(f * 0.01f % 1.0f));
    }

    private static boolean shouldRender(LivingEntity entity, Long shouldRenderFlag) {
        return ClientMagicData.getSyncedSpellData((LivingEntity)entity).hasEffect(shouldRenderFlag.longValue());
    }

    public static class Geo
    extends GeoRenderLayer<AbstractSpellCastingMob> {
        private final ResourceLocation TEXTURE;
        private final Long shouldRenderFlag;

        public Geo(GeoEntityRenderer<AbstractSpellCastingMob> entityRendererIn, ResourceLocation texture, Long shouldRenderFlag) {
            super(entityRendererIn);
            this.TEXTURE = texture;
            this.shouldRenderFlag = shouldRenderFlag;
        }

        public void render(PoseStack poseStack, AbstractSpellCastingMob animatable, BakedGeoModel bakedModel, RenderType renderType2, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (WindySwirlRenderer.shouldRender((LivingEntity)animatable, this.shouldRenderFlag)) {
                float f = (float)animatable.tickCount + partialTick;
                RenderType renderType = WindySwirlRenderer.getRenderType(Aeromancy.id("textures/entity/wind_shield_layer.png"), f);
                VertexConsumer vertexconsumer = bufferSource.getBuffer(renderType);
                poseStack.pushPose();
                bakedModel.getBone("body").ifPresent(rootBone -> rootBone.getChildBones().forEach(bone -> bone.updateScale(1.1f, 1.1f, 1.1f)));
                this.getRenderer().actuallyRender(poseStack, (GeoAnimatable)animatable, bakedModel, renderType, bufferSource, vertexconsumer, true, partialTick, packedLight, OverlayTexture.NO_OVERLAY, COLOR);
                bakedModel.getBone("body").ifPresent(rootBone -> rootBone.getChildBones().forEach(bone -> bone.updateScale(1.0f, 1.0f, 1.0f)));
                poseStack.popPose();
            } else if (WindySwirlRenderer.shouldRender((LivingEntity)animatable, this.shouldRenderFlag)) {
                float f = (float)animatable.tickCount + partialTick;
                RenderType renderType = WindySwirlRenderer.getRenderType(Aeromancy.id("textures/entity/wind_shield_layer.png"), f);
                VertexConsumer vertexconsumer = bufferSource.getBuffer(renderType);
                poseStack.pushPose();
                bakedModel.getBone("head").ifPresent(bone -> bone.setHidden(true));
                bakedModel.getBone("body").ifPresent(rootBone -> rootBone.getChildBones().forEach(bone -> bone.updateScale(1.1f, 1.1f, 1.1f)));
                this.getRenderer().actuallyRender(poseStack, (GeoAnimatable)animatable, bakedModel, renderType, bufferSource, vertexconsumer, true, partialTick, packedLight, OverlayTexture.NO_OVERLAY, COLOR);
                bakedModel.getBone("body").ifPresent(rootBone -> rootBone.getChildBones().forEach(bone -> bone.updateScale(1.0f, 1.0f, 1.0f)));
                poseStack.popPose();
            }
        }
    }

    public static class Vanilla
    extends RenderLayer<Player, HumanoidModel<Player>> {
        public static ModelLayerLocation LAYER = new ModelLayerLocation(IronsSpellbooks.id((String)"energy_layer"), "main");
        private final HumanoidModel<Player> model = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(LAYER));
        private final ResourceLocation TEXTURE;
        private final Long shouldRenderFlag;

        public Vanilla(RenderLayerParent pRenderer, ResourceLocation texture, Long shouldRenderFlag) {
            super(pRenderer);
            this.TEXTURE = texture;
            this.shouldRenderFlag = shouldRenderFlag;
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, Player pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            VertexConsumer vertexconsumer;
            HumanoidModel<Player> entitymodel;
            float f;
            if (WindySwirlRenderer.shouldRender((LivingEntity)pLivingEntity, this.shouldRenderFlag)) {
                pMatrixStack.scale(1.1f, 1.0f, 1.1f);
                f = (float)pLivingEntity.tickCount + pPartialTicks;
                entitymodel = this.model;
                vertexconsumer = pBuffer.getBuffer(WindySwirlRenderer.getRenderType(Aeromancy.id("textures/entity/wind_shield_layer.png"), f));
                ((HumanoidModel)this.getParentModel()).copyPropertiesTo(entitymodel);
                entitymodel.body.render(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, COLOR);
                entitymodel.leftArm.render(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, COLOR);
                entitymodel.rightArm.render(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, COLOR);
                entitymodel.leftLeg.render(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, COLOR);
                entitymodel.rightLeg.render(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, COLOR);
            }
            if (WindySwirlRenderer.shouldRender((LivingEntity)pLivingEntity, 512L)) {
                pMatrixStack.scale(1.1f, 1.0f, 1.1f);
                f = (float)pLivingEntity.tickCount + pPartialTicks;
                entitymodel = this.model;
                vertexconsumer = pBuffer.getBuffer(WindySwirlRenderer.getRenderType(Aeromancy.id("textures/entity/wind_shield_layer.png"), f));
                ((HumanoidModel)this.getParentModel()).copyPropertiesTo(entitymodel);
                entitymodel.head.render(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, COLOR);
            }
        }

        protected HumanoidModel<Player> model() {
            return this.model;
        }
    }
}

