/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.item.AAItems;
import com.snackpirate.aeromancy.spells.AASpells;
import com.snackpirate.aeromancy.spells.airstep.AirstepCounterBar;
import com.snackpirate.aeromancy.spells.airstep.AirstepPacket;
import com.snackpirate.aeromancy.spells.airstep.AirstepSpell;
import com.snackpirate.aeromancy.spells.tornado.TornadoRenderer;
import com.snackpirate.aeromancy.spells.updraft.UpdraftVisualRenderer;
import com.snackpirate.aeromancy.spells.wind_blade.WindBladeRenderer;
import com.snackpirate.aeromancy.spells.wind_charge.MagicWindChargeRenderer;
import com.snackpirate.aeromancy.spells.wind_shield.WindySwirlRenderer;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.render.SpellBookCurioRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.entity.BreezeRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@EventBusSubscriber(modid="aero_additions", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AAClientEvents {
    @SubscribeEvent
    public static void rendererRegister(EntityRenderersEvent.RegisterRenderers event) {
        CuriosRendererRegistry.register((Item)((Item)AAItems.UPDRAFT_TOME.get()), SpellBookCurioRenderer::new);
        event.registerEntityRenderer((EntityType)AASpells.Entities.MAGIC_WIND_CHARGE.get(), MagicWindChargeRenderer::new);
        event.registerEntityRenderer((EntityType)AASpells.Entities.UPDRAFT_VISUAL_ENTITY.get(), UpdraftVisualRenderer::new);
        event.registerEntityRenderer((EntityType)AASpells.Entities.SUMMONED_BREEZE.get(), BreezeRenderer::new);
        event.registerEntityRenderer((EntityType)AASpells.Entities.WIND_BLADE_PROJECTILE.get(), WindBladeRenderer::new);
        event.registerEntityRenderer((EntityType)AASpells.Entities.TORNADO.get(), TornadoRenderer::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.AddLayers event) {
        AAClientEvents.addLayerToPlayerSkin(event, PlayerSkin.Model.SLIM);
        AAClientEvents.addLayerToPlayerSkin(event, PlayerSkin.Model.WIDE);
    }

    private static void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, PlayerSkin.Model skinName) {
        EntityRenderer render = event.getSkin(skinName);
        if (render instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)render;
            livingRenderer.addLayer((RenderLayer)new WindySwirlRenderer.Vanilla((RenderLayerParent)livingRenderer, Aeromancy.id("textures/entity/wind_shield_layer.png"), 2L));
        }
    }

    @SubscribeEvent
    public static void registerLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(IronsSpellbooks.id((String)"mana_overlay"), Aeromancy.id("airstep_counter"), (LayeredDraw.Layer)AirstepCounterBar.instance);
    }

    @EventBusSubscriber(modid="aero_additions", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    static class Game {
        private static boolean wasJumping = false;

        Game() {
        }

        @SubscribeEvent
        private static void handleJump(PlayerTickEvent.Pre event) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player != null && minecraft.player == event.getEntity() && !minecraft.player.isSpectator()) {
                boolean isJumping = minecraft.options.keyJump.isDown();
                if (!wasJumping && isJumping && !event.getEntity().onGround() && !event.getEntity().isFallFlying() && AirstepSpell.canJump((LivingEntity)event.getEntity())) {
                    int x = (minecraft.player.input.up ? 1 : 0) + (minecraft.player.input.down ? -1 : 0);
                    int z = (minecraft.player.input.right ? 1 : 0) + (minecraft.player.input.left ? -1 : 0);
                    AirstepPacket packet = new AirstepPacket(x, z);
                    AirstepSpell.airstepJump(packet, (LivingEntity)event.getEntity());
                    PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                wasJumping = isJumping;
            }
        }
    }
}

