/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.data;

import com.snackpirate.aeromancy.data.AADamageTypes;
import com.snackpirate.aeromancy.data.AAEntityTypeTags;
import com.snackpirate.aeromancy.data.AAItemTags;
import com.snackpirate.aeromancy.data.AALang;
import com.snackpirate.aeromancy.data.AARecipes;
import com.snackpirate.aeromancy.data.AAUpgradeOrbs;
import io.redspace.ironsspellbooks.registries.UpgradeOrbTypeRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="aero_additions", bus=EventBusSubscriber.Bus.MOD)
public class AAData
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, AADamageTypes::bootstrap).add(UpgradeOrbTypeRegistry.UPGRADE_ORB_REGISTRY_KEY, AAUpgradeOrbs::bootstrap);

    public AAData(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider, BUILDER, Set.of("minecraft", "aero_additions"));
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        AAData datapackProvider = new AAData(output, provider);
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        AALang lang = new AALang(output);
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeClient(), (DataProvider)lang);
        generator.addProvider(event.includeServer(), (DataProvider)new AAItemTags(output, provider, CompletableFuture.completedFuture(TagsProvider.TagLookup.empty())));
        generator.addProvider(event.includeServer(), (DataProvider)new AARecipes(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new AAEntityTypeTags(output, provider, "aero_additions", helper));
    }
}

