/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.airstep;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.airstep.AirstepSpell;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AirstepPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<AirstepPacket> TYPE = new CustomPacketPayload.Type(Aeromancy.id("airstep"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AirstepPacket> STREAM_CODEC = CustomPacketPayload.codec(AirstepPacket::write, AirstepPacket::new);
    public final int deltaX;
    public final int deltaZ;

    public AirstepPacket(FriendlyByteBuf buf) {
        this.deltaX = buf.readInt();
        this.deltaZ = buf.readInt();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public AirstepPacket(int x, int z) {
        this.deltaX = x;
        this.deltaZ = z;
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeInt(this.deltaX);
        buf.writeInt(this.deltaZ);
    }

    public static void handle(AirstepPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> AirstepSpell.airstepJump(packet, (LivingEntity)ctx.player()));
    }
}

