/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.feather_fall;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.data.AAItemTags;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import java.util.Objects;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class FlightEffect
extends MagicMobEffect {
    public FlightEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.tickCount % 20 == 0) {
            int weightScore = FlightEffect.calculateWeightScore(pLivingEntity);
            AttributeInstance instance = pLivingEntity.getAttributes().getInstance(Attributes.GRAVITY);
            if (instance != null) {
                instance.removeModifier(Aeromancy.id("flight.gravity"));
                if (weightScore != 0) {
                    instance.addOrUpdateTransientModifier(new AttributeModifier(Aeromancy.id("flight.gravity"), (double)((float)weightScore / 4.0f) - 0.08, AttributeModifier.Operation.ADD_VALUE));
                }
            }
        }
        return super.applyEffectTick(pLivingEntity, pAmplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectRemoved(LivingEntity pLivingEntity, int pAmplifier) {
        Objects.requireNonNull(pLivingEntity.getAttribute(Attributes.GRAVITY)).removeModifier(Aeromancy.id("flight.gravity"));
        super.onEffectRemoved(pLivingEntity, pAmplifier);
    }

    private static int calculateWeightScore(LivingEntity living) {
        int totalScore = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stackInSlot = living.getItemBySlot(slot);
            int itemScore = stackInSlot.is(AAItemTags.FLIGHT_LIGHT) || !living.hasItemInSlot(slot) ? 0 : (stackInSlot.is(AAItemTags.FLIGHT_HEAVY) ? 4 : (stackInSlot.is(ItemTags.ANVIL) ? 10 : 2));
            totalScore += itemScore;
        }
        return totalScore;
    }
}

