/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.summon_breeze;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class SummonedBreezeGoals {

    static class LongJump<T extends Mob>
    extends Goal {
        private final T mob;
        private int attackTime = -1;

        public LongJump(T mob) {
            this.mob = mob;
        }

        public boolean canUse() {
            return ((Mob)this.mob).target != null && ((Mob)this.mob).target.distanceToSqr(this.mob) <= 9.0;
        }
    }

    static class ShootWindCharge<T extends Mob>
    extends Goal {
        private final T mob;
        private final double speedModifier;
        private int attackIntervalMin;
        private final float attackRadiusSqr;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public ShootWindCharge(T mob, double speedMod, int attackIntMin, float atkRadius) {
            this.mob = mob;
            this.speedModifier = speedMod;
            this.attackIntervalMin = attackIntMin;
            this.attackRadiusSqr = atkRadius * atkRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setMinAttackInterval(int attackCooldown) {
            this.attackIntervalMin = attackCooldown;
        }

        public boolean canUse() {
            return this.mob.getTarget() != null && !this.mob.getTarget().isDeadOrDying();
        }

        public boolean canContinueToUse() {
            return this.canUse() || !this.mob.getNavigation().isDone();
        }

        public void start() {
            super.start();
            this.mob.setAggressive(true);
        }

        public void stop() {
            super.stop();
            this.mob.setAggressive(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.mob.stopUsingItem();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                boolean flag1;
                if (livingentity.isDeadOrDying()) {
                    ((Mob)this.mob).target = null;
                    this.stop();
                    return;
                }
                double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                boolean flag = this.mob.getSensing().hasLineOfSight((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.mob.getNavigation().stop();
                    ++this.strafingTime;
                } else {
                    this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    Entity var7 = this.mob.getControlledVehicle();
                    if (var7 instanceof Mob) {
                        Mob mob = (Mob)var7;
                        mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                    }
                    this.mob.lookAt((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                }
                if (--this.attackTime <= 0) {
                    ((RangedAttackMob)this.mob).performRangedAttack(livingentity, 1.0f);
                    this.attackTime = this.attackIntervalMin;
                }
            }
        }
    }
}

