/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.spells.AASpells;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AAOverlay
implements LayeredDraw.Layer {
    private static float ticks;
    public static AAOverlay instance;

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        ticks += deltaTracker.getGameTimeDeltaTicks();
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player != null && Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.hasEffect(AASpells.MobEffects.BREATHLESS)) {
            AAOverlay.renderOverlay(guiGraphics, Aeromancy.id("textures/entity/wind_shield_layer.png"), 0.35f, 0.35f, 0.35f, 0.1f, screenWidth, screenHeight);
        }
    }

    private static void renderOverlay(GuiGraphics gui, ResourceLocation texture, float r, float g, float b, float a, int screenWidth, int screenHeight) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        gui.setColor(r, g, b, a);
        gui.blit(texture, 0, 0, -90, 80.0f * ticks, ticks, screenWidth, screenHeight, 2 * screenWidth, 2 * screenHeight);
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    static {
        instance = new AAOverlay();
    }
}

