/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.airblast;

import com.snackpirate.aeromancy.AASounds;
import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.data.AAEntityTypeTags;
import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class AirblastSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setCooldownSeconds(0.75).setMaxLevel(5).setSchoolResource(AASpells.Schools.WIND_RESOURCE).setMinRarity(SpellRarity.RARE).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"spell.aero_additions.airblast.max_range", (Object[])new Object[]{AirblastSpell.getRadius(spellLevel)}), Component.translatable((String)"spell.aero_additions.airblast.degree_width", (Object[])new Object[]{AirblastSpell.getArc(spellLevel)}), Component.translatable((String)"spell.aero_additions.airblast.deflection_power", (Object[])new Object[]{Utils.stringTruncation((double)(100.0f * this.getSpellPower(spellLevel, (Entity)caster) / this.getSpellPower(1, null)), (int)2)}));
    }

    private static int getArc(int spellLevel) {
        return 20 + 5 * spellLevel;
    }

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("airblast");
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public AirblastSpell() {
        this.manaCostPerLevel = 4;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 30;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        level.getEntitiesOfClass(Projectile.class, entity.getBoundingBox().inflate((double)AirblastSpell.getRadius(spellLevel))).stream().filter(proj -> proj.distanceTo((Entity)entity) < (float)AirblastSpell.getRadius(spellLevel) && !Objects.equals(proj.getOwner(), entity) && AirblastSpell.canBeAirblasted(proj)).forEach(e -> {
            Vec3 casterLookAngle;
            Vec3 casterToProj = e.getPosition(0.0f).subtract(entity.getEyePosition()).normalize();
            float projToLookAngleDeg = (float)Math.acos(casterToProj.dot(casterLookAngle = entity.getLookAngle().normalize())) * 57.295776f;
            if (projToLookAngleDeg < (float)AirblastSpell.getArc(spellLevel)) {
                this.deflect((Projectile)e, (Entity)entity, spellLevel);
            }
        });
        Vec3 particleLoc = entity.getEyePosition().add(entity.getLookAngle().scale(3.0));
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.GUST, (double)particleLoc.x, (double)particleLoc.y, (double)particleLoc.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)true);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    static int getRadius(int spellLevel) {
        return 2 + spellLevel;
    }

    public void deflect(Projectile projectile, Entity deflector, int spellLevel) {
        if (deflector != null) {
            Vec3 vec3 = deflector.getLookAngle().normalize();
            if (deflector instanceof Player) {
                Player p = (Player)deflector;
                vec3 = vec3.scale(0.15 * (double)this.getSpellPower(spellLevel, (Entity)p));
            }
            projectile.setOwner(deflector);
            projectile.setDeltaMovement(vec3);
            projectile.hasImpulse = true;
        }
    }

    public Optional<SoundEvent> getCastStartSound() {
        return AASounds.AIRBLAST_CAST.asOptional();
    }

    public static boolean canBeAirblasted(Projectile p) {
        return !p.getType().is(AAEntityTypeTags.REFLECTION_IMMUNE);
    }
}

