/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.summon_breeze;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.snackpirate.aeromancy.spells.AASpells;
import com.snackpirate.aeromancy.spells.summon_breeze.SummonedBreezeGoals;
import com.snackpirate.aeromancy.spells.wind_charge.MagicWindCharge;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericProtectOwnerTargetGoal;
import java.util.Collection;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SummonedBreeze
extends Breeze
implements IMagicSummon,
RangedAttackMob {
    public SummonedBreeze(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 0;
    }

    public SummonedBreeze(Level level, LivingEntity entity) {
        super((EntityType)AASpells.Entities.SUMMONED_BREEZE.get(), level);
        SummonManager.setOwner((Entity)this, (Entity)entity);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return Brain.provider((Collection)ImmutableList.of(), (Collection)ImmutableList.of()).makeBrain(dynamic);
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null && SummonManager.getOwner((Entity)this) != null && !target.is(SummonManager.getOwner((Entity)this))) {
            super.setTarget(target);
        }
    }

    public void onUnSummon() {
        if (!this.level().isClientSide) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.POOF, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new SummonedBreezeGoals.ShootWindCharge<SummonedBreeze>(this, 1.0, 40, 10.0f));
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, () -> ((SummonedBreeze)this).getSummoner(), (double)0.9f, 15.0f, 5.0f, false, 25.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, () -> ((SummonedBreeze)this).getSummoner()));
        this.targetSelector.addGoal(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, () -> ((SummonedBreeze)this).getSummoner()));
        this.targetSelector.addGoal(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, () -> ((SummonedBreeze)this).getSummoner()));
        this.targetSelector.addGoal(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new GenericProtectOwnerTargetGoal((Mob)this, () -> ((SummonedBreeze)this).getSummoner()));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.shouldIgnoreDamage(pSource)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isAlliedTo(Entity pEntity) {
        return super.isAlliedTo(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void die(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.die(pDamageSource);
    }

    public void onRemovedFromLevel() {
        this.onRemovedHelper((Entity)this);
        super.onRemovedFromLevel();
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public void performRangedAttack(LivingEntity target, float v) {
        MagicWindCharge charge = new MagicWindCharge(this.level(), (LivingEntity)this);
        charge.setPos(this.position().add(0.0, (double)this.getEyeHeight() - charge.getBoundingBox().getYsize() * 0.5, 0.0));
        charge.setDamage(1.0f);
        charge.shoot(this.getLookAngle().subtract(0.0, 0.2, 0.0));
        this.level().addFreshEntity((Entity)charge);
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }
}

