/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.wind_charge;

import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MagicWindCharge
extends WindCharge
implements AntiMagicSusceptible {
    protected float damage;

    public MagicWindCharge(EntityType<? extends WindCharge> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MagicWindCharge(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends WindCharge>)((EntityType)AASpells.Entities.MAGIC_WIND_CHARGE.get()), levelIn);
        this.setOwner((Entity)shooter);
    }

    public void trailParticles() {
    }

    public void shoot(Vec3 rotation) {
        this.setDeltaMovement(rotation.scale((double)this.getSpeed()));
    }

    public void impactParticles(double x, double y, double z) {
    }

    public float getSpeed() {
        return 1.5f;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            Vec3i vec3i = result.getDirection().getNormal();
            Vec3 vec3 = Vec3.atLowerCornerOf((Vec3i)vec3i).multiply(0.25, 0.25, 0.25);
            Vec3 vec31 = result.getLocation().add(vec3);
            this.explode(vec31);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        if (!this.level().isClientSide) {
            DamageSource damagesource;
            Entity var4 = this.getOwner();
            LivingEntity var10000 = var4 instanceof LivingEntity ? (LivingEntity)var4 : null;
            LivingEntity livingentity = var10000;
            Entity entity = pResult.getEntity();
            if (livingentity != null) {
                livingentity.setLastHurtMob(entity);
                if (livingentity instanceof Player) {
                    Player p = (Player)livingentity;
                    p.setIgnoreFallDamageFromCurrentImpulse(true);
                }
            }
            if (entity.hurt(damagesource = this.damageSources().windCharge((Entity)this, livingentity), 1.0f) && entity instanceof LivingEntity) {
                LivingEntity livingentity2 = (LivingEntity)entity;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)livingentity2, (DamageSource)damagesource);
            }
            this.explode(this.position());
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void explode(Vec3 pos) {
        this.level().explode((Entity)this, null, MagicWindCharge.getCalculator(1.22f * this.getDamage()), pos.x(), pos.y(), pos.z(), 1.5f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
    }

    public boolean isNoGravity() {
        return true;
    }

    private static ExplosionDamageCalculator getCalculator(float damage) {
        return new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(damage)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.explode(this.position());
        this.discard();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("Damage", this.getDamage());
        tag.putInt("Age", this.tickCount);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.damage = tag.getFloat("Damage");
        this.tickCount = tag.getInt("Age");
    }
}

