/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.network.AeromancySpellData;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class ShapeshiftSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(3).setCooldownSeconds(70.0).build();

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("shapeshift");
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public ShapeshiftSpell() {
        this.manaCostPerLevel = 7;
        this.baseSpellPower = 30;
        this.spellPowerPerLevel = 10;
        this.castTime = 30;
        this.baseManaCost = 60;
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)5, (float)0.15f)) {
            LivingEntity target = ((TargetEntityCastData)playerMagicData.getAdditionalCastData()).getTarget((ServerLevel)level);
            if (target == null) {
                return false;
            }
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(target));
            return true;
        }
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            ServerLevel server;
            TargetEntityCastData target = (TargetEntityCastData)iCastData;
            if (level instanceof ServerLevel && target.getTarget(server = (ServerLevel)level) != null) {
                AeromancySpellData.getAeromancyData(entity).setShapeshiftId(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getTarget(server).getType()));
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }
}

