/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells;

import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import io.redspace.ironsspellbooks.effect.ISyncedMobEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="aero_additions")
public class StunEffect
extends MobEffect
implements ISyncedMobEffect {
    protected StunEffect(MobEffectCategory category, int color, ParticleOptions particle) {
        super(category, color, particle);
    }

    @SubscribeEvent
    public static void tryApply(MobEffectEvent.Applicable event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(AASpells.MobEffects.STUNNED)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onApply(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (event.getEffectInstance() != null && event.getEffectInstance().is(AASpells.MobEffects.STUNNED)) {
                MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)entity);
                SpellSelectionManager selections = new SpellSelectionManager(p);
                PlayerCooldowns cooldowns = magicData.getPlayerCooldowns();
                selections.getAllSpells().forEach(selectionOption -> {
                    AbstractSpell spell = selectionOption.spellData.getSpell();
                    if (!cooldowns.isOnCooldown(spell)) {
                        cooldowns.addCooldown(spell, spell.getSpellCooldown() / 2);
                    }
                });
                if (p instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)p;
                    cooldowns.syncToPlayer(sp);
                }
            }
        }
    }
}

