/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.airstep;

import com.snackpirate.aeromancy.Aeromancy;
import com.snackpirate.aeromancy.network.AeromancySpellData;
import com.snackpirate.aeromancy.spells.AASpells;
import com.snackpirate.aeromancy.spells.airstep.AirstepPacket;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="aero_additions")
@AutoSpellConfig
public class AirstepSpell
extends AbstractSpell {
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(AASpells.Schools.WIND_RESOURCE).setMaxLevel(7).setCooldownSeconds(90.0).build();

    public ResourceLocation getSpellResource() {
        return Aeromancy.id("airstep");
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"spell.aero_additions.airstep.max_jumps", (Object[])new Object[]{1 + spellLevel}), Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel, caster), (int)1)}));
    }

    public AirstepSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 30;
        this.spellPowerPerLevel = 10;
        this.castTime = 30;
        this.baseManaCost = 60;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public SchoolType getSchoolType() {
        return AASpells.Schools.WIND.get();
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.addEffect(new MobEffectInstance(AASpells.MobEffects.AIRSTEPPING, this.getDuration(spellLevel, entity), spellLevel - 1));
        AeromancySpellData.getAeromancyData(entity).setAirStepHitsRemaining(1 + spellLevel);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    @SubscribeEvent
    static void protectFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.hasEffect(AASpells.MobEffects.AIRSTEPPING)) {
            return;
        }
        int spellLevel = 1 + entity.getEffect(AASpells.MobEffects.AIRSTEPPING).getAmplifier();
        if ((double)event.getDistance() >= event.getEntity().getAttributeValue(Attributes.SAFE_FALL_DISTANCE) && AirstepSpell.hasJumps(entity)) {
            event.setDamageMultiplier(0.0f);
            if (!entity.level().isClientSide) {
                MagicManager.spawnParticles((Level)event.getEntity().level(), (ParticleOptions)ParticleTypes.SPIT, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (int)10, (double)0.2, (double)0.0, (double)0.2, (double)0.3, (boolean)true);
            }
            entity.playSound(SoundEvents.BREEZE_JUMP, 2.0f, 0.9f + Utils.random.nextFloat() * 0.2f);
        }
        AeromancySpellData.getAeromancyData(entity).setAirStepHitsRemaining(1 + spellLevel);
    }

    public static boolean airstepJump(AirstepPacket packet, LivingEntity entity) {
        if (!AirstepSpell.canJump(entity)) {
            return false;
        }
        Level level = entity.level();
        Vec3 input = new Vec3((double)packet.deltaX, 0.0, (double)packet.deltaZ).yRot(-((float)Mth.atan2((double)entity.getLookAngle().z, (double)entity.getLookAngle().x))).normalize().scale(0.5);
        Vec3 motion = input.add(0.0, entity.getAttributeValue(Attributes.JUMP_STRENGTH) + (double)entity.getJumpBoostPower(), 0.0);
        entity.setDeltaMovement(motion);
        entity.resetFallDistance();
        if (!entity.level().isClientSide) {
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleTypes.SPIT, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (int)10, (double)0.2, (double)0.0, (double)0.2, (double)0.3, (boolean)true);
        }
        entity.hasImpulse = true;
        entity.playSound(SoundEvents.BREEZE_JUMP, 2.0f, 0.9f + Utils.random.nextFloat() * 0.2f);
        AeromancySpellData.getAeromancyData(entity).subtractAirStepHits();
        return true;
    }

    public static boolean canJump(LivingEntity entity) {
        return AirstepSpell.hasJumps(entity) && entity.hasEffect(AASpells.MobEffects.AIRSTEPPING) && !entity.onGround();
    }

    @SubscribeEvent
    static void effectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().is(AASpells.MobEffects.AIRSTEPPING)) {
            AeromancySpellData.getAeromancyData(event.getEntity()).setAirStepHitsRemaining(0);
        }
    }

    static boolean hasJumps(LivingEntity entity) {
        return AeromancySpellData.getAeromancyData(entity).getAirStepHitsRemaining() > 0;
    }

    @SubscribeEvent
    static void effectRemoved(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().is(AASpells.MobEffects.AIRSTEPPING)) {
            AeromancySpellData.getAeromancyData(event.getEntity()).setAirStepHitsRemaining(0);
        }
    }

    public Optional<SoundEvent> getCastStartSound() {
        return super.getCastStartSound();
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.TOUCH_GROUND_ANIMATION;
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 30.0f);
    }
}

