/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.aeromancy.spells.tornado;

import com.snackpirate.aeromancy.spells.AASpells;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TornadoEntity
extends Projectile
implements AntiMagicSusceptible,
GeoAnimatable {
    private static final EntityDataAccessor<Float> DATA_SIZE = SynchedEntityData.defineId(TornadoEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_EFFECT = SynchedEntityData.defineId(TornadoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int loopSoundDurationInTicks = 320;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final AnimationController<TornadoEntity> controller = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);
    List<Entity> trackingEntities = new ArrayList<Entity>();

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("spin", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public TornadoEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public TornadoEntity(Level pLevel, LivingEntity owner) {
        this((EntityType<? extends Projectile>)((EntityType)AASpells.Entities.TORNADO.get()), pLevel);
        this.setOwner((Entity)owner);
    }

    public void setSize(float size) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_SIZE, (Object)Float.valueOf(Math.min(size, 48.0f)));
        }
    }

    public float getSize() {
        return ((Float)this.getEntityData().get(DATA_SIZE)).floatValue();
    }

    public void setEffect(TornadoEffect effect) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_EFFECT, (Object)effect.id());
        }
    }

    public TornadoEffect getEffect() {
        return TornadoEffect.BY_ID.apply((Integer)this.getEntityData().get(DATA_EFFECT));
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_SIZE.equals(pKey)) {
            this.refreshDimensions();
            if (this.getSize() < 0.1f) {
                this.discard();
            }
        }
        super.onSyncedDataUpdated(pKey);
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putFloat("Size", this.getSize());
        pCompound.putInt("Age", this.tickCount);
        pCompound.putInt("Effect", this.getEffect().id());
        super.addAdditionalSaveData(pCompound);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        this.tickCount = pCompound.getInt("Age");
        this.setEffect(TornadoEffect.BY_ID.apply(pCompound.getInt("Effect")));
        if (pCompound.getInt("Size") > 0) {
            this.setSize(pCompound.getFloat("Size"));
        }
        super.readAdditionalSaveData(pCompound);
    }

    public void onAntiMagic(MagicData playerMagicData) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SIZE, (Object)Float.valueOf(1.0f));
        builder.define(DATA_EFFECT, (Object)TornadoEffect.DEFAULT.id());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
    }

    public boolean displayFireAnimation() {
        return false;
    }

    @NotNull
    public EntityDimensions getDimensions(Pose pPose) {
        return EntityDimensions.scalable((float)(this.getSize() * 1.5f), (float)this.getSize());
    }

    public void tick() {
        super.tick();
        int update = Math.max((int)(this.getSize() / 2.0f), 2);
        if (this.tickCount % update == 0) {
            this.updateTrackingEntities();
        }
        AABB bb = this.getBoundingBox();
        float radius = (float)bb.getXsize();
        boolean hitTick = this.tickCount % 10 == 0;
        for (Entity entity : this.trackingEntities) {
            float f;
            if (entity == this.getOwner() || DamageSources.isFriendlyFireBetween((Entity)this.getOwner(), (Entity)entity) || entity.isSpectator()) continue;
            Vec3 centerFromY = bb.getBottomCenter();
            centerFromY = new Vec3(centerFromY.x, entity.getY(), centerFromY.z);
            float distanceToColumn = (float)centerFromY.distanceTo(entity.position());
            if (distanceToColumn > radius) continue;
            if (distanceToColumn < 2.0f) {
                this.checkForApplicableEffects(entity);
            }
            if (hitTick && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (distanceToColumn < 2.0f) {
                    this.applyDamage(living);
                }
            }
            float f2 = 1.0f - distanceToColumn / radius;
            float heightInColumn = Math.max((float)(entity.getY() - bb.getMinPosition().y), 1.0f) / 3.0f;
            float scale = f2 * f2 * f2 * f2 * 0.25f;
            Vec3 inwardsSuction = centerFromY.subtract(entity.position()).normalize().scale((double)(scale * heightInColumn));
            Vec3 spinny = inwardsSuction.yRot(4.712389f).scale((double)(scale * 2.0f * heightInColumn));
            if (entity.position().y > bb.getMaxPosition().y - 1.5) {
                LivingEntity living;
                spinny = spinny.scale(4.0);
                if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).hasEffect((Holder)MobEffectRegistry.AIRBORNE)) {
                    living.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.AIRBORNE, 200, (int)this.getSize()));
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = Mth.clamp((float)(1.0f - (float)livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)), (float)0.3f, (float)1.0f);
            } else {
                f = 1.0f;
            }
            float resistance = f;
            float bossResistance = entity.getType().is(Tags.EntityTypes.BOSSES) ? 0.5f : 1.0f;
            Vec3 pushForce = new Vec3(0.0, (double)(scale * resistance * bossResistance) * 0.7, 0.0).add(inwardsSuction).add(spinny);
            entity.push(pushForce);
            entity.fallDistance = 0.0f;
        }
        if (!this.level().isClientSide) {
            if (this.tickCount > 6400) {
                this.discard();
            } else if ((this.tickCount - 1) % 320 == 0) {
                // empty if block
            }
        }
    }

    public void applyDamage(LivingEntity e) {
        switch (this.getEffect().ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                DamageSources.applyDamage((Entity)e, (float)2.0f, (DamageSource)((AbstractSpell)SpellRegistry.FIRE_BREATH_SPELL.get()).getDamageSource((Entity)this, this.getOwner()));
                break;
            }
            case 2: {
                DamageSources.applyDamage((Entity)e, (float)2.0f, (DamageSource)((AbstractSpell)SpellRegistry.DRAGON_BREATH_SPELL.get()).getDamageSource((Entity)this, this.getOwner()));
                break;
            }
            case 3: {
                if (!DamageSources.applyDamage((Entity)e, (float)2.0f, (DamageSource)((AbstractSpell)SpellRegistry.POISON_BREATH_SPELL.get()).getDamageSource((Entity)this, this.getOwner())) || !(e instanceof LivingEntity)) break;
                LivingEntity livingEntity = e;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 0));
                break;
            }
            case 4: {
                DamageSources.applyDamage((Entity)e, (float)2.0f, (DamageSource)((AbstractSpell)SpellRegistry.ELECTROCUTE_SPELL.get()).getDamageSource((Entity)this, this.getOwner()));
                if (this.level().isClientSide()) break;
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleHelper.ELECTRICITY, (double)e.getX(), (double)(e.getY() + (double)(e.getBbHeight() / 2.0f)), (double)e.getZ(), (int)10, (double)(e.getBbWidth() / 3.0f), (double)(e.getBbHeight() / 3.0f), (double)(e.getBbWidth() / 3.0f), (double)0.1, (boolean)false);
            }
        }
    }

    public void checkForApplicableEffects(Entity e) {
        for (TornadoEffect effect : TornadoEffect.values()) {
            if (!e.getType().equals(effect.entity)) continue;
            this.setEffect(effect);
        }
    }

    private void updateTrackingEntities() {
        this.trackingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0));
    }

    public static enum TornadoEffect {
        DEFAULT(0, (EntityType)AASpells.Entities.MAGIC_WIND_CHARGE.get(), AASpells.WIND_CHARGE.get()),
        FIRE(1, (EntityType)EntityRegistry.FIRE_BREATH_PROJECTILE.get(), (AbstractSpell)SpellRegistry.FIRE_BREATH_SPELL.get()),
        ENDER(2, (EntityType)EntityRegistry.DRAGON_BREATH_PROJECTILE.get(), (AbstractSpell)SpellRegistry.DRAGON_BREATH_SPELL.get()),
        NATURE(3, (EntityType)EntityRegistry.POISON_BREATH_PROJECTILE.get(), (AbstractSpell)SpellRegistry.POISON_BREATH_SPELL.get()),
        LIGHTNING(4, (EntityType)EntityRegistry.ELECTROCUTE_PROJECTILE.get(), (AbstractSpell)SpellRegistry.ELECTROCUTE_SPELL.get());

        public static final IntFunction<TornadoEffect> BY_ID;
        private final int id;
        private final EntityType<?> entity;
        private final AbstractSpell spell;

        private TornadoEffect(int id, EntityType<?> entity, AbstractSpell spell) {
            this.id = id;
            this.entity = entity;
            this.spell = spell;
        }

        public int id() {
            return this.id;
        }

        public EntityType<?> entity() {
            return this.entity;
        }

        public AbstractSpell spell() {
            return this.spell;
        }

        static {
            BY_ID = ByIdMap.continuous(TornadoEffect::id, (Object[])TornadoEffect.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

