/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class KevsLibraryConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("kevslibrary.json");
    private static KevsLibraryConfig INSTANCE;
    public Map<String, Boolean> attributes = new HashMap<String, Boolean>();
    public Map<String, Boolean> systems = new HashMap<String, Boolean>();
    private static final Map<String, List<String>> SYSTEM_ATTRIBUTES;

    public KevsLibraryConfig() {
        this.attributes.put("crit_chance", true);
        this.attributes.put("crit_damage", true);
        this.attributes.put("multistrike_chance", true);
        this.attributes.put("multistrike_count", true);
        this.attributes.put("multistrike_damage", true);
        this.attributes.put("damage", true);
        this.attributes.put("chain_lightning_chance", true);
        this.attributes.put("chain_lightning_count", true);
        this.attributes.put("chain_lightning_overload_chance", true);
        this.attributes.put("fire_tornado_chance", true);
        this.attributes.put("fire_tornado_overload_chance", true);
        this.attributes.put("frost_nova_chance", true);
        this.attributes.put("frost_nova_count", true);
        this.attributes.put("frost_nova_overload_chance", true);
        this.attributes.put("pet_inheritance_ratio", true);
        this.attributes.put("pet_damage_bonus", true);
        this.attributes.put("soul_link_chance", true);
        this.attributes.put("soul_link_damage", true);
        this.attributes.put("arcane_rupture_chance", true);
        this.attributes.put("arcane_rupture_damage", true);
        this.attributes.put("arcane_rupture_overload_chance", true);
        this.attributes.put("trident_damage_multiplier", true);
        this.attributes.put("armor_penetration", true);
        this.attributes.put("armor_penetration_flat", true);
        this.attributes.put("thorns_chance", true);
        this.attributes.put("thorns_amp", true);
        this.attributes.put("thorns_true_damage_chance", true);
        this.attributes.put("cleave_chance", true);
        this.attributes.put("cleave_damage_multiplier", true);
        this.attributes.put("cleave_range", true);
        this.attributes.put("pierce_chance", true);
        this.attributes.put("barrage_chance", true);
        this.attributes.put("projectile_storm_chance", true);
        this.attributes.put("projectile_storm_range", true);
        this.attributes.put("projectile_storm_duration", true);
        this.attributes.put("hunger_consumption", true);
        this.systems.put("multistrike", true);
        this.systems.put("chain_lightning", true);
        this.systems.put("fire_tornado", true);
        this.systems.put("frost_nova", true);
        this.systems.put("soul_link", true);
        this.systems.put("arcane_rupture", true);
        this.systems.put("thorns", true);
        this.systems.put("cleave", true);
        this.systems.put("piercing", true);
        this.systems.put("barrage", true);
        this.systems.put("projectile_storm", true);
        this.systems.put("pet_inheritance", true);
        this.systems.put("crit", true);
        this.systems.put("damage", true);
        this.systems.put("trident", true);
        this.systems.put("armor_penetration", true);
        this.systems.put("hunger", true);
    }

    public static KevsLibraryConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = KevsLibraryConfig.load();
        }
        return INSTANCE;
    }

    public static void reload() {
        INSTANCE = KevsLibraryConfig.load();
    }

    private static KevsLibraryConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                KevsLibraryConfig config = (KevsLibraryConfig)GSON.fromJson(json, KevsLibraryConfig.class);
                KevsLibraryConfig defaults = new KevsLibraryConfig();
                boolean needsSave = false;
                for (Map.Entry<String, Boolean> entry : defaults.attributes.entrySet()) {
                    if (config.attributes.containsKey(entry.getKey())) continue;
                    config.attributes.put(entry.getKey(), entry.getValue());
                    needsSave = true;
                }
                for (Map.Entry<String, Boolean> entry : defaults.systems.entrySet()) {
                    if (config.systems.containsKey(entry.getKey())) continue;
                    config.systems.put(entry.getKey(), entry.getValue());
                    needsSave = true;
                }
                if (needsSave) {
                    config.save();
                }
                return config;
            }
            catch (IOException e) {
                return new KevsLibraryConfig();
            }
        }
        KevsLibraryConfig config = new KevsLibraryConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isAttributeEnabled(String attributeName) {
        if (!this.attributes.getOrDefault(attributeName, false).booleanValue()) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : SYSTEM_ATTRIBUTES.entrySet()) {
            String systemName;
            if (!entry.getValue().contains(attributeName) || this.systems.getOrDefault(systemName = entry.getKey(), false).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isSystemEnabled(String systemName) {
        if (!this.systems.getOrDefault(systemName, false).booleanValue()) {
            return false;
        }
        List<String> requiredAttrs = SYSTEM_ATTRIBUTES.get(systemName);
        if (requiredAttrs != null) {
            for (String attrName : requiredAttrs) {
                if (this.attributes.getOrDefault(attrName, false).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isCritEnabled() {
        return this.isSystemEnabled("crit");
    }

    public boolean isMultistrikeEnabled() {
        return this.isSystemEnabled("multistrike");
    }

    public boolean isChainLightningEnabled() {
        return this.isSystemEnabled("chain_lightning");
    }

    public boolean isFireTornadoEnabled() {
        return this.isSystemEnabled("fire_tornado");
    }

    public boolean isFrostNovaEnabled() {
        return this.isSystemEnabled("frost_nova");
    }

    public boolean isSoulLinkEnabled() {
        return this.isSystemEnabled("soul_link");
    }

    public boolean isArcaneRuptureEnabled() {
        return this.isSystemEnabled("arcane_rupture");
    }

    public boolean isThornsEnabled() {
        return this.isSystemEnabled("thorns");
    }

    public boolean isCleaveEnabled() {
        return this.isSystemEnabled("cleave");
    }

    public boolean isPiercingEnabled() {
        return this.isSystemEnabled("piercing");
    }

    public boolean isBarrageEnabled() {
        return this.isSystemEnabled("barrage");
    }

    public boolean isProjectileStormEnabled() {
        return this.isSystemEnabled("projectile_storm");
    }

    public boolean isPetInheritanceEnabled() {
        return this.isSystemEnabled("pet_inheritance");
    }

    public boolean isArmorPenetrationEnabled() {
        return this.isSystemEnabled("armor_penetration");
    }

    public boolean isDamageEnabled() {
        return this.isSystemEnabled("damage");
    }

    public boolean isTridentEnabled() {
        return this.isSystemEnabled("trident");
    }

    public boolean isHungerEnabled() {
        return this.isSystemEnabled("hunger");
    }

    public List<String> getSystemAttributes(String systemName) {
        return SYSTEM_ATTRIBUTES.get(systemName);
    }

    static {
        SYSTEM_ATTRIBUTES = new HashMap<String, List<String>>();
        SYSTEM_ATTRIBUTES.put("multistrike", Arrays.asList("multistrike_chance", "multistrike_count", "multistrike_damage"));
        SYSTEM_ATTRIBUTES.put("chain_lightning", Arrays.asList("chain_lightning_chance", "chain_lightning_count", "chain_lightning_overload_chance"));
        SYSTEM_ATTRIBUTES.put("fire_tornado", Arrays.asList("fire_tornado_chance", "fire_tornado_overload_chance"));
        SYSTEM_ATTRIBUTES.put("frost_nova", Arrays.asList("frost_nova_chance", "frost_nova_count", "frost_nova_overload_chance"));
        SYSTEM_ATTRIBUTES.put("soul_link", Arrays.asList("soul_link_chance", "soul_link_damage"));
        SYSTEM_ATTRIBUTES.put("arcane_rupture", Arrays.asList("arcane_rupture_chance", "arcane_rupture_damage", "arcane_rupture_overload_chance"));
        SYSTEM_ATTRIBUTES.put("thorns", Arrays.asList("thorns_chance", "thorns_amp", "thorns_true_damage_chance"));
        SYSTEM_ATTRIBUTES.put("cleave", Arrays.asList("cleave_chance", "cleave_damage_multiplier", "cleave_range"));
        SYSTEM_ATTRIBUTES.put("piercing", Arrays.asList("pierce_chance"));
        SYSTEM_ATTRIBUTES.put("barrage", Arrays.asList("barrage_chance"));
        SYSTEM_ATTRIBUTES.put("projectile_storm", Arrays.asList("projectile_storm_chance", "projectile_storm_range", "projectile_storm_duration"));
        SYSTEM_ATTRIBUTES.put("pet_inheritance", Arrays.asList("pet_inheritance_ratio", "pet_damage_bonus"));
        SYSTEM_ATTRIBUTES.put("crit", Arrays.asList("crit_chance", "crit_damage"));
        SYSTEM_ATTRIBUTES.put("damage", Arrays.asList("damage"));
        SYSTEM_ATTRIBUTES.put("trident", Arrays.asList("trident_damage_multiplier"));
        SYSTEM_ATTRIBUTES.put("armor_penetration", Arrays.asList("armor_penetration", "armor_penetration_flat"));
        SYSTEM_ATTRIBUTES.put("hunger", Arrays.asList("hunger_consumption"));
    }
}

