/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1671;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.util.DelayedExecutor;

public final class BarrageHandler {
    private static final int EXTRA_SHOTS = 2;
    private static final int TICKS_BETWEEN_SHOTS = 3;

    private BarrageHandler() {
    }

    public static void tryBarrage(class_1309 shooter, class_1799 weaponStack, class_1799 projectileTemplate, float baseSpeed, float baseDivergence) {
        double chance;
        class_1937 class_19372 = shooter.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_1324 chanceAttr = shooter.method_5996(KevsLibrary.BARRAGE_CHANCE);
        double d = chance = chanceAttr != null ? chanceAttr.method_6194() : 0.0;
        if (chance <= 0.0) {
            return;
        }
        if (world.method_8409().method_43058() > chance) {
            return;
        }
        if (projectileTemplate == null || projectileTemplate.method_7960()) {
            projectileTemplate = new class_1799((class_1935)class_1802.field_8107);
        }
        for (int i = 0; i < 2; ++i) {
            int delay = (i + 1) * 3;
            class_1799 projCopy = projectileTemplate.method_7972();
            DelayedExecutor.runLater(() -> BarrageHandler.spawnFromTemplate(world, shooter, weaponStack, projCopy, baseSpeed, baseDivergence), delay);
        }
    }

    private static void spawnFromTemplate(class_3218 world, class_1309 shooter, class_1799 weaponStack, class_1799 projectileStack, float speed, float divergence) {
        if (!shooter.method_5805()) {
            return;
        }
        if (projectileStack.method_31574(class_1802.field_8639)) {
            class_1671 rocket = new class_1671((class_1937)world, projectileStack, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - 0.15, shooter.method_23321(), true);
            class_243 dir = shooter.method_5828(1.0f);
            rocket.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.6f, divergence);
            world.method_8649((class_1297)rocket);
            return;
        }
        class_1792 dir = projectileStack.method_7909();
        if (dir instanceof class_1744) {
            class_1744 arrowItem = (class_1744)dir;
            class_1665 arrow = arrowItem.method_7702((class_1937)world, projectileStack, shooter, weaponStack);
            arrow.field_7572 = class_1665.class_1666.field_7594;
            int power = BarrageHandler.getLevelOn(shooter, (class_5321<class_1887>)class_1893.field_9103, weaponStack);
            if (power > 0) {
                arrow.method_7438(arrow.method_7448() + 0.5 * (double)power + 0.5);
            }
            if (BarrageHandler.getLevelOn(shooter, (class_5321<class_1887>)class_1893.field_9126, weaponStack) > 0) {
                arrow.method_5639(100.0f);
            }
            float pitch = shooter.method_36455();
            float yaw = shooter.method_36454();
            arrow.method_24919((class_1297)shooter, pitch, yaw, 0.0f, speed, divergence);
            if (speed >= 2.9f && arrow instanceof class_1667) {
                class_1667 ae = (class_1667)arrow;
                ae.method_7439(true);
            }
            world.method_8649((class_1297)arrow);
        }
    }

    private static int getLevelOn(class_1309 ctx, class_5321<class_1887> key, class_1799 stack) {
        return ctx.method_56673().method_30530(class_7924.field_41265).method_40264(key).map(entry -> class_1890.method_8225((class_6880)entry, (class_1799)stack)).orElse(0);
    }

    public static float bowSpeedFromPull(float pullProgress) {
        return class_3532.method_15363((float)pullProgress, (float)0.0f, (float)1.0f) * 3.0f;
    }

    public static float crossbowBaseSpeed() {
        return 3.15f;
    }
}

