/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.entity.IcicleProjectileEntity;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkTracker;
import net.pixeldreamstudios.kevslibrary.util.DelayedExecutor;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class FrostNovaHandler {
    private static final double RADIUS = 5.0;
    private static final float BASE_DAMAGE = 3.0f;
    private static final int SLOW_DURATION = 60;
    private static final int COOLDOWN_TICKS = 40;
    private static final Map<UUID, Long> LAST_NOVA = new HashMap<UUID, Long>();

    public static void triggerFrostNova(class_1309 attacker) {
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        UUID attackerId = attacker.method_5667();
        long currentTime = world.method_8510();
        if (currentTime - LAST_NOVA.getOrDefault(attackerId, 0L) < 40L) {
            return;
        }
        LAST_NOVA.put(attackerId, currentTime);
        int novaCount = attacker.method_5996(KevsLibrary.FROST_NOVA_COUNT) != null ? (int)attacker.method_45325(KevsLibrary.FROST_NOVA_COUNT) : 1;
        class_1324 overloadAttr = attacker.method_5996(KevsLibrary.FROST_NOVA_OVERLOAD_CHANCE);
        double overloadChance = overloadAttr != null ? overloadAttr.method_6194() : 0.0;
        int overloadedWave = -1;
        if (attacker.method_59922().method_43058() < overloadChance) {
            overloadedWave = attacker.method_59922().method_43048(novaCount);
        }
        for (int i = 0; i < novaCount; ++i) {
            int delay = i * 10;
            int waveIndex = i;
            boolean overloaded = waveIndex == overloadedWave;
            List targetsSnapshot = world.method_8390(class_1309.class, attacker.method_5829().method_1014(5.0 + (double)(novaCount * 2)), e -> FrostNovaHandler.isValidTarget(e, attacker));
            DelayedExecutor.runLater(() -> FrostNovaHandler.doFrostNova(attacker, waveIndex, overloaded, targetsSnapshot), delay);
        }
    }

    private static void doFrostNova(class_1309 attacker, int waveIndex, boolean overloaded, List<class_1309> targets) {
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        SpellPower.Result result = SpellPower.getSpellPower((SpellSchool)SpellSchools.FROST, (class_1309)attacker);
        SpellPower.Result.Value rawResult = result.nonCritical();
        float base = 3.0f + (float)result.baseValue();
        float critChance = (float)result.criticalChance();
        float critMultiplier = (float)result.criticalDamage();
        float dmgMult = 1.0f;
        class_1324 dmgAttr = attacker.method_5996(KevsLibrary.DAMAGE);
        if (dmgAttr != null) {
            dmgMult = (float)dmgAttr.method_6194();
        }
        if (overloaded) {
            world.method_14199((class_2394)class_2398.field_11230, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 40, 0.7, 0.6, 0.7, 0.04);
            world.method_14199((class_2394)class_2398.field_28013, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 30, 0.4, 0.3, 0.4, 0.01);
            world.method_14199((class_2394)class_2398.field_11204, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 20, 0.4, 0.1, 0.4, 0.02);
            world.method_8396(null, attacker.method_24515(), class_3417.field_15081, class_3419.field_15248, 1.1f, 0.8f);
        }
        double radius = 5.0 + (double)waveIndex * 1.5;
        float pitch = 0.9f + (float)waveIndex * 0.05f;
        world.method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_43154, class_3419.field_15248, 0.7f, pitch);
        for (int i = 0; i < 24; ++i) {
            double angle = (double)i / 24.0 * Math.PI * 2.0;
            double x = attacker.method_23317() + Math.cos(angle) * radius;
            double z = attacker.method_23321() + Math.sin(angle) * radius;
            double y = attacker.method_23318() + 1.2;
            world.method_14199((class_2394)class_2398.field_28013, x, y, z, 1, 0.1, 0.1, 0.1, 0.01);
            if (!overloaded) continue;
            world.method_14199((class_2394)class_2398.field_11207, x, y + 0.3, z, 1, 0.05, 0.05, 0.05, 0.005);
        }
        world.method_14199((class_2394)class_2398.field_11204, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 10, 0.5, 0.1, 0.5, 0.01);
        world.method_14199((class_2394)class_2398.field_11230, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 6, 0.2, 0.3, 0.2, 0.02);
        targets = world.method_8390(class_1309.class, attacker.method_5829().method_1014(radius), e -> FrostNovaHandler.isValidTarget(e, attacker));
        for (class_1309 target : targets) {
            SpellPower.Vulnerability vuln = SpellPower.getVulnerability((class_1309)target, (SpellSchool)SpellSchools.FROST);
            float raw = base * (1.0f + vuln.powerBaseMultiplier());
            boolean isCrit = attacker.method_59922().method_43058() < (double)(critChance + vuln.criticalChanceBonus());
            float critApplied = isCrit ? raw * (critMultiplier + vuln.criticalDamageBonus()) : raw;
            float finalDamage = critApplied * dmgMult;
            if (overloaded) {
                finalDamage *= 1.5f;
            }
            target.method_5643(attacker.method_48923().method_48831(), finalDamage);
            float finalDamage1 = finalDamage;
            SoulLinkTracker.getGroup(target).ifPresent(linkData -> {
                if (!attacker.method_5667().equals(linkData.attacker().method_5667())) {
                    return;
                }
                SoulLinkHandler.handleLinkedDamage(linkData.attacker(), target, finalDamage1, linkData.group(), linkData.soulPower());
            });
            class_243 knock = target.method_19538().method_1020(attacker.method_19538()).method_1029().method_1021(0.4 + 0.1 * (double)waveIndex);
            target.method_5762(knock.field_1352, 0.2, knock.field_1350);
            target.method_32317(60);
            world.method_14199((class_2394)class_2398.field_11230, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 8, 0.3, 0.3, 0.3, 0.01);
            if (isCrit) {
                world.method_14199((class_2394)class_2398.field_11205, target.method_23317(), target.method_23318() + 1.2, target.method_23321(), 8, 0.3, 0.2, 0.3, 0.01);
                world.method_14199((class_2394)class_2398.field_28013, target.method_23317(), target.method_23318() + 1.4, target.method_23321(), 8, 0.25, 0.25, 0.25, 0.01);
                world.method_8396(null, target.method_24515(), class_3417.field_15165, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (!overloaded) continue;
            FrostNovaHandler.spawnIcicleBurst(world, attacker, target, finalDamage * 0.75f);
        }
    }

    private static void spawnIcicleBurst(class_3218 world, class_1309 attacker, class_1309 origin, float icicleDamage) {
        class_243 basePos = origin.method_19538();
        int count = attacker.method_5996(KevsLibrary.FROST_NOVA_COUNT) != null ? (int)attacker.method_45325(KevsLibrary.FROST_NOVA_COUNT) * 2 : 2;
        for (int i = 0; i < count; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 1.2;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.2;
            double spawnY = basePos.field_1351 + (double)origin.method_17682() + 0.5;
            class_243 spawnPos = new class_243(basePos.field_1352 + offsetX, spawnY, basePos.field_1350 + offsetZ);
            IcicleProjectileEntity icicle = IcicleProjectileEntity.create((class_1937)world, attacker, icicleDamage);
            icicle.method_5814(spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350);
            double upwardPower = 0.6 + world.field_9229.method_43058() * 0.4;
            double spreadX = (world.field_9229.method_43058() - 0.5) * 0.3;
            double spreadZ = (world.field_9229.method_43058() - 0.5) * 0.3;
            icicle.method_18800(spreadX, upwardPower, spreadZ);
            world.method_8649((class_1297)icicle);
        }
        world.method_8396(null, origin.method_24515(), class_3417.field_14583, class_3419.field_15251, 0.6f, 1.5f);
        world.method_14199((class_2394)class_2398.field_28013, basePos.field_1352, basePos.field_1351 + (double)origin.method_17682() + 1.0, basePos.field_1350, 20, 0.4, 0.2, 0.4, 0.01);
    }

    private static boolean isValidTarget(class_1309 entity, class_1309 attacker) {
        class_1321 tameable;
        if (!entity.method_5805()) {
            return false;
        }
        if (entity.equals((Object)attacker)) {
            return false;
        }
        if (entity.method_5722((class_1297)attacker)) {
            return false;
        }
        if (!(entity instanceof class_1657) && entity.method_5864().method_5891().method_6136()) {
            return false;
        }
        return !(entity instanceof class_1321) || !(tameable = (class_1321)entity).method_6181();
    }
}

