/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.pixeldreamstudios.kevslibrary.KevsDamageTypes;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.handler.OnHitEffectHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkTracker;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;

public class MultistrikeHandler {
    private static final Set<UUID> handledProjectiles = Collections.newSetFromMap(new WeakHashMap());
    private static final Map<UUID, List<HoveringSpellProjectile>> hoveringSpellProjectiles = new HashMap<UUID, List<HoveringSpellProjectile>>();
    private static final Map<String, MultistrikeBomb> bombs = new HashMap<String, MultistrikeBomb>();
    private static final Map<UUID, List<HoveringArrow>> hoveringArrows = new HashMap<UUID, List<HoveringArrow>>();

    public static boolean tryMarkProjectile(UUID uuid) {
        return handledProjectiles.add(uuid);
    }

    public static void triggerMultistrike(class_1309 attacker, class_1309 target, float damage, class_1799 weaponUsed) {
        if (!MultistrikeHandler.isValidMultistrikeTarget(attacker, target)) {
            return;
        }
        String key = String.valueOf(attacker.method_5667()) + "|" + String.valueOf(target.method_5667());
        bombs.compute(key, (k, existing) -> {
            if (existing == null) {
                return new MultistrikeBomb(attacker, target, damage, weaponUsed);
            }
            existing.addStack(damage);
            return existing;
        });
    }

    public static void spawnHoveringProjectiles(class_1309 attacker, class_1309 target, float baseDamage, class_1297 sourceProjectile, class_1799 weaponUsed) {
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_1324 countAttr = attacker.method_5996(KevsLibrary.MULTISTRIKE_COUNT);
        int count = countAttr != null ? (int)countAttr.method_6194() : 1;
        class_1324 dmgAttr = attacker.method_5996(KevsLibrary.MULTISTRIKE_DAMAGE);
        float multiplier = dmgAttr != null ? (float)dmgAttr.method_6194() : 0.5f;
        float finalDamage = baseDamage * multiplier * 0.6f;
        class_243 forward = attacker.method_5828(1.0f).method_1029();
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 right = forward.method_1036(up).method_1029();
        for (int i = 0; i < count; ++i) {
            boolean fromRight;
            class_243 spawnPos;
            if (count >= 3) {
                double angle = Math.PI * 2 / (double)count * (double)i;
                class_243 side = right.method_1021(Math.sin(angle)).method_1029();
                spawnPos = attacker.method_19538().method_1019(side.method_1021(1.0)).method_1031(0.0, (double)attacker.method_17682() * 0.6, 0.0);
                fromRight = side.method_1026(right) > 0.0;
            } else {
                class_243 side = i % 2 == 0 ? right : right.method_1021(-1.0);
                spawnPos = attacker.method_19538().method_1019(side.method_1021(1.0)).method_1031(0.0, (double)attacker.method_17682() * 0.6, 0.0);
                boolean bl = fromRight = i % 2 == 0;
            }
            if (sourceProjectile instanceof SpellProjectile) {
                SpellProjectile spellProj = (SpellProjectile)sourceProjectile;
                float msMultiplier = multiplier;
                SpellHelper.ImpactContext baseCtx = spellProj.getImpactContext();
                SpellHelper.ImpactContext scaledCtx = baseCtx.distance(baseCtx.distance() * msMultiplier);
                SpellProjectile newSpell = new SpellProjectile((class_1937)world, attacker, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, spellProj.getBehaviour(), spellProj.getSpellEntry(), scaledCtx, spellProj.mutablePerks().copy());
                class_243 toTarget = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0).method_1020(attacker.method_19538());
                class_243 forwardDir = toTarget.method_1029();
                class_243 sideVec = forwardDir.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
                class_243 offsetCurve = sideVec.method_1021(fromRight ? 0.6 : -0.6);
                class_243 launchDir = forwardDir.method_1019(offsetCurve).method_1029().method_1021(1.5);
                newSpell.method_18799(launchDir);
                newSpell.method_36456((float)(Math.toDegrees(Math.atan2(launchDir.field_1350, launchDir.field_1352)) - 90.0));
                newSpell.method_36457((float)(-Math.toDegrees(Math.atan2(launchDir.field_1351, launchDir.method_37267()))));
                newSpell.method_5847(newSpell.method_36454());
                newSpell.method_5636(newSpell.method_36454());
                newSpell.method_5803(true);
                newSpell.method_5834(true);
                newSpell.method_5780("multistrike_spell");
                world.method_8649((class_1297)newSpell);
                hoveringSpellProjectiles.computeIfAbsent(attacker.method_5667(), k -> new ArrayList()).add(new HoveringSpellProjectile(newSpell, attacker, target));
                continue;
            }
            if (sourceProjectile instanceof class_1665) {
                class_1665 projectile = (class_1665)sourceProjectile;
                class_1299 type = projectile.method_5864();
                class_1297 newArrowEntity = type.method_5883((class_1937)world);
                if (!(newArrowEntity instanceof class_1665)) continue;
                class_1665 arrow = (class_1665)newArrowEntity;
                arrow.method_7432((class_1297)attacker);
                float dmgToSet = projectile instanceof class_1685 ? baseDamage * multiplier : finalDamage;
                arrow.method_7439(true);
                arrow.method_7438((double)dmgToSet);
                arrow.method_5803(true);
                arrow.method_5834(true);
                arrow.method_5875(true);
                arrow.field_7572 = class_1665.class_1666.field_7592;
                arrow.method_33574(spawnPos);
                arrow.method_18799(class_243.field_1353);
                world.method_8649((class_1297)arrow);
                arrow.field_7572 = class_1665.class_1666.field_7592;
                arrow.method_5880(false);
                arrow.method_5665(class_2561.method_30163((String)"multistrike_arrow"));
                arrow.method_5780("multistrike_arrow");
                double angleOffset = Math.PI * 2 / (double)count * (double)i;
                int delay = 30 + i * 10;
                hoveringArrows.computeIfAbsent(attacker.method_5667(), k -> new ArrayList()).add(new HoveringArrow(arrow, attacker, target, angleOffset, delay, fromRight));
                continue;
            }
            MultistrikeHandler.triggerMultistrike(attacker, target, baseDamage, weaponUsed);
            break;
        }
    }

    public static void tick(class_3218 world) {
        Iterator<Map.Entry<String, MultistrikeBomb>> bombIt = bombs.entrySet().iterator();
        while (bombIt.hasNext()) {
            Map.Entry<String, MultistrikeBomb> entry = bombIt.next();
            MultistrikeBomb bomb = entry.getValue();
            boolean done = bomb.tick(world);
            if (!done) continue;
            bombIt.remove();
        }
        Iterator<Map.Entry<UUID, List<HoveringSpellProjectile>>> spellIt = hoveringSpellProjectiles.entrySet().iterator();
        while (spellIt.hasNext()) {
            Map.Entry<UUID, List<HoveringSpellProjectile>> entry = spellIt.next();
            List<HoveringSpellProjectile> projectiles = entry.getValue();
            projectiles.removeIf(p -> p.tick(world));
            if (!projectiles.isEmpty()) continue;
            spellIt.remove();
        }
        Iterator<Map.Entry<UUID, List<HoveringArrow>>> it = hoveringArrows.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, List<HoveringArrow>> entry = it.next();
            UUID attackerId = entry.getKey();
            List<HoveringArrow> arrows = entry.getValue();
            arrows.removeIf(arrow -> arrow.tick(world));
            if (!arrows.isEmpty()) continue;
            it.remove();
        }
        world.method_27909().forEach(entity -> {
            class_1665 ppe;
            if (entity instanceof class_1665 && (ppe = (class_1665)entity).method_5752().contains("multistrike_arrow") && ppe.field_6012 > 200 && (ppe.method_24921() == null || ppe.method_31481())) {
                ppe.method_31472();
            }
        });
    }

    private static boolean isValidMultistrikeTarget(class_1309 attacker, class_1309 target) {
        class_1321 tameable;
        return target.method_5805() && !target.equals((Object)attacker) && !target.method_5722((class_1297)attacker) && (!(target instanceof class_1321) || !(tameable = (class_1321)target).method_6181());
    }

    private static class HoveringSpellProjectile {
        final SpellProjectile projectile;
        final class_1309 attacker;
        final class_1309 target;
        int ticksSinceLaunch = 0;
        private static final int MAX_LIFESPAN = 200;
        private static final double HOMING_FORCE = 0.25;
        private static final double SPEED = 1.5;

        HoveringSpellProjectile(SpellProjectile projectile, class_1309 attacker, class_1309 target) {
            this.projectile = projectile;
            this.attacker = attacker;
            this.target = target;
        }

        boolean tick(class_3218 world) {
            if (!this.projectile.method_5805() || !this.target.method_5805() || this.target.method_31481()) {
                this.projectile.method_31472();
                return true;
            }
            ++this.ticksSinceLaunch;
            if (this.ticksSinceLaunch > 200) {
                this.projectile.method_31472();
                return true;
            }
            class_243 toTarget = this.target.method_19538().method_1031(0.0, (double)this.target.method_17682() * 0.5, 0.0).method_1020(this.projectile.method_19538());
            class_243 homing = toTarget.method_1029().method_1021(0.25);
            this.projectile.method_18799(this.projectile.method_18798().method_1019(homing).method_1029().method_1021(1.5));
            world.method_14199((class_2394)class_2398.field_11207, this.projectile.method_23317(), this.projectile.method_23318(), this.projectile.method_23321(), 1, 0.0, 0.0, 0.0, 0.001);
            return false;
        }
    }

    private static class HoveringArrow {
        final class_1665 arrow;
        final class_1309 attacker;
        final class_1309 target;
        final boolean fromRightSide;
        boolean launched = false;
        int ticksSinceSpawn = 0;
        private static final int MAX_LIFESPAN = 400;
        private static final double INITIAL_SPEED = 1.5;
        private static final double HOMING_FORCE = 0.3;
        private static final double TARGET_RADIUS = 0.6;
        private int ticksSinceLaunch = 0;

        HoveringArrow(class_1665 arrow, class_1309 attacker, class_1309 target, double angleOffset, int delayBeforeLaunch, boolean fromRightSide) {
            this.arrow = arrow;
            this.attacker = attacker;
            this.target = target;
            this.fromRightSide = fromRightSide;
        }

        boolean tick(class_3218 world) {
            if (!this.arrow.method_5805()) {
                return true;
            }
            if (!this.attacker.method_5805() || !this.target.method_5805() || this.attacker.method_31481()) {
                this.arrow.method_31472();
                return true;
            }
            if (!this.attacker.method_37908().equals(this.arrow.method_37908())) {
                this.arrow.method_31472();
                return true;
            }
            ++this.ticksSinceSpawn;
            if (this.ticksSinceSpawn > 400) {
                this.arrow.method_31472();
                return true;
            }
            if (!this.launched) {
                this.launchArrow(world);
                this.launched = true;
            }
            if (this.launched) {
                ++this.ticksSinceLaunch;
                if (this.ticksSinceLaunch >= 10) {
                    class_243 toTarget = this.target.method_19538().method_1031(0.0, (double)this.target.method_17682() * 0.8, 0.0).method_1020(this.arrow.method_19538());
                    class_243 homing = toTarget.method_1029().method_1021(0.3);
                    this.arrow.method_18799(this.arrow.method_18798().method_1019(homing).method_1029().method_1021(1.5));
                }
                world.method_14199((class_2394)class_2398.field_11207, this.arrow.method_23317(), this.arrow.method_23318(), this.arrow.method_23321(), 1, 0.0, 0.0, 0.0, 0.001);
                if (this.arrow.method_30949((class_1297)this.target)) {
                    if (!MultistrikeHandler.isValidMultistrikeTarget(this.attacker, this.target)) {
                        this.arrow.method_31472();
                        return true;
                    }
                    float damage = (float)this.arrow.method_7448();
                    class_1282 source = this.attacker.method_48923().method_48796(KevsDamageTypes.MULTISTRIKE_RANGED, (class_1297)this.attacker);
                    int prevRegen = this.target.field_6008;
                    int prevHurt = this.target.field_6235;
                    this.target.field_6008 = 0;
                    this.target.field_6235 = 0;
                    boolean hit = this.target.method_5643(source, damage);
                    this.target.field_6008 = prevRegen;
                    this.target.field_6235 = prevHurt;
                    if (hit) {
                        OnHitEffectHandler.withMultistrikeContext(() -> OnHitEffectHandler.triggerAll(this.attacker, this.target, damage));
                        SoulLinkTracker.getGroup(this.target).ifPresent(linkData -> SoulLinkHandler.handleLinkedDamage(linkData.attacker(), this.target, damage, linkData.group(), linkData.soulPower()));
                        world.method_14199((class_2394)class_2398.field_38908, this.target.method_23317(), this.target.method_23318() + 1.0, this.target.method_23321(), 5, 0.3, 0.3, 0.3, 0.01);
                    }
                    this.arrow.method_31472();
                    return true;
                }
            }
            return false;
        }

        void launchArrow(class_3218 world) {
            this.arrow.method_5875(false);
            class_243 toTarget = this.target.method_19538().method_1031(0.0, (double)this.target.method_17682() * 0.5, 0.0).method_1020(this.attacker.method_19538());
            class_243 forward = toTarget.method_1029();
            class_243 side = forward.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            class_243 offsetCurve = side.method_1021(this.fromRightSide ? 0.6 : -0.6);
            class_243 launchDirection = forward.method_1019(offsetCurve).method_1029().method_1021(1.5);
            this.arrow.method_18799(launchDirection);
            this.arrow.method_37908().method_8396(null, this.arrow.method_24515(), class_3417.field_14600, class_3419.field_15248, 0.4f, 0.4f);
        }
    }

    private static class MultistrikeBomb {
        private final class_1309 target;
        private final class_1309 source;
        private final class_1799 weaponUsed;
        private int strikeIndex = 0;
        private float totalDamage;
        private int totalStrikes = 0;
        private int triggerCount = 0;
        private boolean detonating = false;
        private float diminishingTimerAdd = 0.5f;
        private int ticksUntilDetonate = 60;
        private long lastStrikeTime = 0L;

        public MultistrikeBomb(class_1309 source, class_1309 target, float damage, class_1799 weaponUsed) {
            this.source = source;
            this.target = target;
            this.weaponUsed = weaponUsed.method_7972();
            this.totalDamage = damage;
            this.totalStrikes = this.getStrikeCountFromAttributes(source);
            this.triggerCount = 1;
        }

        public void addStack(float damage) {
            this.totalDamage += damage;
            ++this.triggerCount;
            int addedStrikes = this.getStrikeCountFromAttributes(this.source);
            this.totalStrikes += addedStrikes;
            this.ticksUntilDetonate += (int)(20.0f * Math.max(this.diminishingTimerAdd, 0.0f));
            this.diminishingTimerAdd -= 0.1f;
        }

        public boolean tick(class_3218 world) {
            if (!this.target.method_5805()) {
                return true;
            }
            long time = world.method_8510();
            if (!this.detonating) {
                --this.ticksUntilDetonate;
                if (this.ticksUntilDetonate == 20) {
                    world.method_14199((class_2394)class_2398.field_38908, this.target.method_23317(), this.target.method_23318() + 1.0, this.target.method_23321(), 2, 0.5, 0.3, 0.5, 0.05);
                }
                if (this.ticksUntilDetonate > 0) {
                    return false;
                }
                this.detonating = true;
                this.lastStrikeTime = time;
                world.method_14199((class_2394)class_2398.field_11224, this.target.method_23317(), this.target.method_23318() + (double)this.target.method_17682() + 0.6, this.target.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
                return false;
            }
            int delay = this.strikeIndex < 5 ? 3 - this.strikeIndex : 0;
            if (delay > 0 && time - this.lastStrikeTime < (long)delay) {
                return false;
            }
            this.lastStrikeTime = time;
            if (!this.target.method_5805()) {
                return true;
            }
            if (this.totalStrikes <= 0) {
                return true;
            }
            if (!MultistrikeHandler.isValidMultistrikeTarget(this.source, this.target)) {
                return true;
            }
            float avgDamage = this.totalDamage / (float)this.triggerCount;
            class_1324 dmgAttr = this.source.method_5996(KevsLibrary.MULTISTRIKE_DAMAGE);
            float multiplier = dmgAttr != null ? (float)dmgAttr.method_6194() : 0.5f;
            float damage = avgDamage * multiplier;
            class_1282 source = world.method_48963().method_48796(KevsDamageTypes.MULTISTRIKE, (class_1297)this.source);
            this.target.field_6235 = 0;
            this.target.field_6008 = 0;
            boolean hit = this.target.method_5643(source, damage);
            if (hit) {
                OnHitEffectHandler.withMultistrikeContext(() -> {
                    OnHitEffectHandler.triggerAll(this.source, this.target, damage);
                    SoulLinkTracker.getGroup(this.target).ifPresent(linkData -> SoulLinkHandler.handleLinkedDamage(linkData.attacker(), this.target, damage, linkData.group(), linkData.soulPower()));
                });
            }
            if (this.strikeIndex == 0) {
                world.method_8396(null, this.target.method_24515(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.0f);
            }
            world.method_14199((class_2394)class_2398.field_38908, this.target.method_23317(), this.target.method_23318() + 1.0, this.target.method_23321(), 2, 0.5, 0.3, 0.5, 0.05);
            --this.totalStrikes;
            ++this.strikeIndex;
            return this.totalStrikes <= 0;
        }

        private int getStrikeCountFromAttributes(class_1309 source) {
            class_1324 countAttr = source.method_5996(KevsLibrary.MULTISTRIKE_COUNT);
            return countAttr != null ? (int)countAttr.method_6194() : 1;
        }
    }
}

