/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.util.DelayedExecutor;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;

public final class ProjectileStormHandler {
    private static final String USED_TAG = "kevslib_storm_used";
    private static final String STORM_TAG = "kevslib_storm_projectile";
    private static final float DAMAGE_RATIO = 0.15f;
    private static final float FALL_SPEED = 1.15f;
    private static final int TELEGRAPH_MIN = 10;
    private static final int RAIN_INTERVAL = 2;

    private ProjectileStormHandler() {
    }

    public static void tryTrigger(class_1665 projectile, class_243 impactCenter, class_1309 targetForHeight) {
        int duration;
        class_1309 l;
        class_1309 owner;
        class_1937 class_19372 = projectile.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_1297 class_12972 = projectile.method_24921();
        class_1309 class_13092 = owner = class_12972 instanceof class_1309 ? (l = (class_1309)class_12972) : null;
        if (owner == null) {
            return;
        }
        if (ProjectileStormHandler.isStormTag((class_1297)projectile) || projectile.method_5752().contains(USED_TAG)) {
            return;
        }
        projectile.method_5780(USED_TAG);
        double chance = owner.method_45325(KevsLibrary.PROJECTILE_STORM_CHANCE);
        if (chance <= 0.0 || world.method_8409().method_43058() > chance) {
            return;
        }
        float radius = (float)owner.method_45325(KevsLibrary.PROJECTILE_STORM_RANGE);
        if (radius <= 0.0f) {
            radius = 5.0f;
        }
        if ((duration = (int)Math.round(owner.method_45325(KevsLibrary.PROJECTILE_STORM_DURATION))) <= 0) {
            duration = 30;
        }
        if (projectile instanceof class_1685) {
            return;
        }
        double originalSpeed = projectile.method_18798().method_1033();
        float originalFinal = (float)(originalSpeed * projectile.method_7448());
        float stormDamage = Math.max(0.1f, originalFinal * 0.15f);
        double spawnY = targetForHeight != null ? impactCenter.field_1351 + (double)targetForHeight.method_17682() + 4.0 : impactCenter.field_1351 + 6.0;
        int teleTicks = Math.min(10, Math.max(6, duration / 3));
        ProjectileStormHandler.telegraphCircle(world, impactCenter, spawnY, radius, teleTicks);
        ProjectileStormHandler.persistCircle(world, impactCenter, spawnY, radius, teleTicks + duration);
        ProjectileStormHandler.startRain(world, owner, impactCenter, spawnY, radius, duration, (w, x, y, z) -> {
            double wobble;
            class_1297 copy = class_1299.field_6122.method_5883((class_1937)w);
            if (!(copy instanceof class_1665)) {
                return;
            }
            class_1665 ppe = (class_1665)copy;
            ppe.method_7432((class_1297)owner);
            ppe.method_5780(STORM_TAG);
            ppe.field_7572 = class_1665.class_1666.field_7594;
            ppe.method_5814(x, y, z);
            double vx = wobble = (w.method_8409().method_43058() - 0.5) * 0.04;
            double vy = -1.15f;
            double vz = wobble;
            ppe.method_18800(vx, vy, vz);
            double fallSpeedLen = Math.sqrt(vx * vx + vy * vy + vz * vz);
            float baseForThisFall = (float)((double)stormDamage / Math.max(0.1, fallSpeedLen));
            ppe.method_7438((double)baseForThisFall);
            w.method_8649((class_1297)ppe);
        });
        if (!(projectile instanceof class_1685) && world.method_8409().method_43056()) {
            projectile.method_31472();
        }
    }

    public static void tryTrigger(SpellProjectile spell, class_243 impactCenter, class_1309 targetForHeight) {
        int duration;
        class_1309 l;
        class_1309 owner;
        class_1937 class_19372 = spell.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_1297 class_12972 = spell.method_24921();
        class_1309 class_13092 = owner = class_12972 instanceof class_1309 ? (l = (class_1309)class_12972) : null;
        if (owner == null) {
            return;
        }
        if (ProjectileStormHandler.isStormTag((class_1297)spell) || spell.method_5752().contains(USED_TAG)) {
            return;
        }
        spell.method_5780(USED_TAG);
        double chance = owner.method_45325(KevsLibrary.PROJECTILE_STORM_CHANCE);
        if (chance <= 0.0 || world.method_8409().method_43058() > chance) {
            return;
        }
        float radius = (float)owner.method_45325(KevsLibrary.PROJECTILE_STORM_RANGE);
        if (radius <= 0.0f) {
            radius = 2.5f;
        }
        if ((duration = (int)Math.round(owner.method_45325(KevsLibrary.PROJECTILE_STORM_DURATION))) <= 0) {
            duration = 30;
        }
        SpellHelper.ImpactContext baseCtx = spell.getImpactContext();
        SpellHelper.ImpactContext scaledCtx = baseCtx.distance(baseCtx.distance() * 0.15f);
        double spawnY = targetForHeight != null ? impactCenter.field_1351 + (double)targetForHeight.method_17682() + 4.0 : impactCenter.field_1351 + 6.0;
        int teleTicks = Math.min(10, Math.max(6, duration / 3));
        ProjectileStormHandler.telegraphCircle(world, impactCenter, spawnY, radius, teleTicks);
        ProjectileStormHandler.persistCircle(world, impactCenter, spawnY, radius, teleTicks + duration);
        ProjectileStormHandler.startRain(world, owner, impactCenter, spawnY, radius, duration, (w, x, y, z) -> {
            SpellProjectile drop = new SpellProjectile((class_1937)w, owner, x, y, z, spell.getBehaviour(), spell.getSpellEntry(), scaledCtx, spell.mutablePerks().copy());
            drop.method_5780(STORM_TAG);
            drop.method_18800(0.0, (double)-1.15f, 0.0);
            drop.method_36456(0.0f);
            drop.method_36457(90.0f);
            drop.method_5803(true);
            w.method_8649((class_1297)drop);
        });
    }

    private static void telegraphCircle(class_3218 world, class_243 center, double y, float radius, int telegraphTicks) {
        for (int t = 0; t < telegraphTicks; ++t) {
            int tick = t;
            DelayedExecutor.runLater(() -> {
                float r = radius * ((float)(tick + 1) / (float)telegraphTicks);
                ProjectileStormHandler.ring(world, center.field_1352, y, center.field_1350, r, 48, (class_2394)class_2398.field_11215);
                ProjectileStormHandler.disc(world, center.field_1352, y, center.field_1350, r * 0.9f, 5, 16);
            }, t);
        }
        DelayedExecutor.runLater(() -> ProjectileStormHandler.ring(world, center.field_1352, y, center.field_1350, radius, 64, (class_2394)class_2398.field_28479), telegraphTicks);
    }

    private static void persistCircle(class_3218 world, class_243 center, double y, float radius, int totalTicks) {
        for (int t = 0; t < totalTicks; t += 2) {
            int delay = t;
            DelayedExecutor.runLater(() -> ProjectileStormHandler.disc(world, center.field_1352, y, center.field_1350, radius * 0.95f, 6, 18), delay);
        }
    }

    private static void startRain(class_3218 world, class_1309 owner, class_243 center, double spawnY, float radius, int durationTicks, Spawner spawner) {
        int startDelay = Math.min(10, Math.max(6, durationTicks / 3));
        int ticks = Math.max(1, durationTicks);
        double density = Math.max(1.0, (double)radius * 0.8);
        int perBurst = Math.max(1, (int)Math.floor(density));
        class_5819 r = world.method_8409();
        for (int i = 0; i < ticks; i += 2) {
            int delay = startDelay + i;
            DelayedExecutor.runLater(() -> {
                if (!owner.method_5805()) {
                    return;
                }
                for (int k = 0; k < perBurst; ++k) {
                    double a = r.method_43058() * Math.PI * 2.0;
                    double rr = Math.pow(r.method_43058(), 0.7) * (double)radius;
                    double x = center.field_1352 + Math.cos(a) * rr;
                    double z = center.field_1350 + Math.sin(a) * rr;
                    spawner.spawn(world, x, spawnY, z);
                }
            }, delay);
        }
    }

    private static void disc(class_3218 world, double cx, double y, double cz, float radius, int rings, int perRing) {
        long t = world.method_8510();
        double swirl = (double)(t % 40L) * 0.15;
        for (int r = 1; r <= rings; ++r) {
            float rr = radius * ((float)r / (float)rings);
            int points = (int)((double)perRing * (0.6 + 0.4 * (double)((float)r / (float)rings)));
            for (int i = 0; i < points; ++i) {
                double a = swirl + (double)i / (double)points * Math.PI * 2.0;
                double x = cx + Math.cos(a) * (double)rr;
                double z = cz + Math.sin(a) * (double)rr;
                world.method_14199((class_2394)class_2398.field_11215, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                if ((i & 3) != 0) continue;
                world.method_14199((class_2394)class_2398.field_11207, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void ring(class_3218 world, double cx, double y, double cz, float radius, int points, class_2394 type) {
        for (int i = 0; i < points; ++i) {
            double a = (double)i / (double)points * Math.PI * 2.0;
            double x = cx + Math.cos(a) * (double)radius;
            double z = cz + Math.sin(a) * (double)radius;
            world.method_14199(type, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isStormTag(class_1297 e) {
        return e.method_5752().contains(STORM_TAG);
    }

    @FunctionalInterface
    private static interface Spawner {
        public void spawn(class_3218 var1, double var2, double var4, double var6);
    }
}

