/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.api.CritEvents;
import net.pixeldreamstudios.kevslibrary.config.KevsLibraryConfig;
import net.pixeldreamstudios.kevslibrary.handler.ArcaneRuptureHandler;
import net.pixeldreamstudios.kevslibrary.handler.ChainLightningHandler;
import net.pixeldreamstudios.kevslibrary.handler.CleaveHandler;
import net.pixeldreamstudios.kevslibrary.handler.FireTornadoHandler;
import net.pixeldreamstudios.kevslibrary.handler.FrostNovaHandler;
import net.pixeldreamstudios.kevslibrary.handler.MultistrikeHandler;
import net.pixeldreamstudios.kevslibrary.handler.OnHitEffectHandler;
import net.pixeldreamstudios.kevslibrary.handler.PiercingHandler;
import net.pixeldreamstudios.kevslibrary.handler.ProjectileStormHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkTracker;
import net.pixeldreamstudios.kevslibrary.handler.ThornsHandler;
import net.spell_engine.entity.SpellProjectile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    private static final ThreadLocal<Boolean> IN_CLEAVE_CONTEXT = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Float> CRIT_DAMAGE_TRACKER = new ThreadLocal();
    private static final ThreadLocal<Boolean> IS_CRIT_FLAG = new ThreadLocal();

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void bypassMultistrike(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_5525().equals("multistrike") || source.method_5525().equals("multistrike_ranged")) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void injectGlobalAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        KevsLibraryConfig config = KevsLibraryConfig.getInstance();
        class_5132.class_5133 builder = (class_5132.class_5133)cir.getReturnValue();
        if (config.isAttributeEnabled("crit_chance") && KevsLibrary.CRIT_CHANCE != null) {
            builder.method_26868(KevsLibrary.CRIT_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("crit_damage") && KevsLibrary.CRIT_DAMAGE != null) {
            builder.method_26868(KevsLibrary.CRIT_DAMAGE, 1.5);
        }
        if (config.isAttributeEnabled("multistrike_chance") && KevsLibrary.MULTISTRIKE_CHANCE != null) {
            builder.method_26868(KevsLibrary.MULTISTRIKE_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("multistrike_count") && KevsLibrary.MULTISTRIKE_COUNT != null) {
            builder.method_26868(KevsLibrary.MULTISTRIKE_COUNT, 2.0);
        }
        if (config.isAttributeEnabled("multistrike_damage") && KevsLibrary.MULTISTRIKE_DAMAGE != null) {
            builder.method_26868(KevsLibrary.MULTISTRIKE_DAMAGE, 0.5);
        }
        if (config.isAttributeEnabled("damage") && KevsLibrary.DAMAGE != null) {
            builder.method_26868(KevsLibrary.DAMAGE, 1.0);
        }
        if (config.isAttributeEnabled("chain_lightning_chance") && KevsLibrary.CHAIN_LIGHTNING_CHANCE != null) {
            builder.method_26868(KevsLibrary.CHAIN_LIGHTNING_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("chain_lightning_count") && KevsLibrary.CHAIN_LIGHTNING_COUNT != null) {
            builder.method_26868(KevsLibrary.CHAIN_LIGHTNING_COUNT, 3.0);
        }
        if (config.isAttributeEnabled("chain_lightning_overload_chance") && KevsLibrary.CHAIN_LIGHTNING_OVERLOAD_CHANCE != null) {
            builder.method_26868(KevsLibrary.CHAIN_LIGHTNING_OVERLOAD_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("fire_tornado_chance") && KevsLibrary.FIRE_TORNADO_CHANCE != null) {
            builder.method_26868(KevsLibrary.FIRE_TORNADO_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("fire_tornado_overload_chance") && KevsLibrary.FIRE_TORNADO_OVERLOAD_CHANCE != null) {
            builder.method_26868(KevsLibrary.FIRE_TORNADO_OVERLOAD_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("frost_nova_chance") && KevsLibrary.FROST_NOVA_CHANCE != null) {
            builder.method_26868(KevsLibrary.FROST_NOVA_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("frost_nova_count") && KevsLibrary.FROST_NOVA_COUNT != null) {
            builder.method_26868(KevsLibrary.FROST_NOVA_COUNT, 3.0);
        }
        if (config.isAttributeEnabled("frost_nova_overload_chance") && KevsLibrary.FROST_NOVA_OVERLOAD_CHANCE != null) {
            builder.method_26868(KevsLibrary.FROST_NOVA_OVERLOAD_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("soul_link_chance") && KevsLibrary.SOUL_LINK_CHANCE != null) {
            builder.method_26868(KevsLibrary.SOUL_LINK_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("soul_link_damage") && KevsLibrary.SOUL_LINK_DAMAGE != null) {
            builder.method_26868(KevsLibrary.SOUL_LINK_DAMAGE, 1.0);
        }
        if (config.isAttributeEnabled("arcane_rupture_chance") && KevsLibrary.ARCANE_RUPTURE_CHANCE != null) {
            builder.method_26868(KevsLibrary.ARCANE_RUPTURE_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("arcane_rupture_damage") && KevsLibrary.ARCANE_RUPTURE_DAMAGE != null) {
            builder.method_26868(KevsLibrary.ARCANE_RUPTURE_DAMAGE, 1.0);
        }
        if (config.isAttributeEnabled("arcane_rupture_overload_chance") && KevsLibrary.ARCANE_RUPTURE_OVERLOAD_CHANCE != null) {
            builder.method_26868(KevsLibrary.ARCANE_RUPTURE_OVERLOAD_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("trident_damage_multiplier") && KevsLibrary.TRIDENT_DAMAGE_MULTIPLIER != null) {
            builder.method_26868(KevsLibrary.TRIDENT_DAMAGE_MULTIPLIER, 1.0);
        }
        if (config.isAttributeEnabled("armor_penetration") && KevsLibrary.ARMOR_PENETRATION != null) {
            builder.method_26868(KevsLibrary.ARMOR_PENETRATION, 0.0);
        }
        if (config.isAttributeEnabled("armor_penetration_flat") && KevsLibrary.ARMOR_PENETRATION_FLAT != null) {
            builder.method_26868(KevsLibrary.ARMOR_PENETRATION_FLAT, 0.0);
        }
        if (config.isAttributeEnabled("thorns_chance") && KevsLibrary.THORNS_CHANCE != null) {
            builder.method_26868(KevsLibrary.THORNS_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("thorns_amp") && KevsLibrary.THORNS_AMP != null) {
            builder.method_26868(KevsLibrary.THORNS_AMP, 0.0);
        }
        if (config.isAttributeEnabled("thorns_true_damage_chance") && KevsLibrary.THORNS_TRUE_DAMAGE_CHANCE != null) {
            builder.method_26868(KevsLibrary.THORNS_TRUE_DAMAGE_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("cleave_damage_multiplier") && KevsLibrary.CLEAVE_DAMAGE_MULTIPLIER != null) {
            builder.method_26868(KevsLibrary.CLEAVE_DAMAGE_MULTIPLIER, 1.0);
        }
        if (config.isAttributeEnabled("cleave_range") && KevsLibrary.CLEAVE_RANGE != null) {
            builder.method_26868(KevsLibrary.CLEAVE_RANGE, 4.0);
        }
        if (config.isAttributeEnabled("cleave_chance") && KevsLibrary.CLEAVE_CHANCE != null) {
            builder.method_26868(KevsLibrary.CLEAVE_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("pierce_chance") && KevsLibrary.PIERCING_CHANCE != null) {
            builder.method_26868(KevsLibrary.PIERCING_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("barrage_chance") && KevsLibrary.BARRAGE_CHANCE != null) {
            builder.method_26868(KevsLibrary.BARRAGE_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("projectile_storm_chance") && KevsLibrary.PROJECTILE_STORM_CHANCE != null) {
            builder.method_26868(KevsLibrary.PROJECTILE_STORM_CHANCE, 0.0);
        }
        if (config.isAttributeEnabled("projectile_storm_range") && KevsLibrary.PROJECTILE_STORM_RANGE != null) {
            builder.method_26868(KevsLibrary.PROJECTILE_STORM_RANGE, 5.0);
        }
        if (config.isAttributeEnabled("projectile_storm_duration") && KevsLibrary.PROJECTILE_STORM_DURATION != null) {
            builder.method_26868(KevsLibrary.PROJECTILE_STORM_DURATION, 60.0);
        }
        if (config.isAttributeEnabled("hunger_consumption") && KevsLibrary.HUNGER_CONSUMPTION != null) {
            builder.method_26868(KevsLibrary.HUNGER_CONSUMPTION, 1.0);
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), index=2, argsOnly=true)
    private float applyCritToDamage(float amount, class_1282 source) {
        class_1324 dmgMultAttr;
        class_6862 magicTag;
        class_1324 tridentMultiplierAttr;
        KevsLibraryConfig config = KevsLibraryConfig.getInstance();
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            CRIT_DAMAGE_TRACKER.set(null);
            IS_CRIT_FLAG.set(null);
            return amount;
        }
        class_1309 attacker = (class_1309)class_12972;
        if (source.method_5525().equals("multistrike") || source.method_5525().equals("multistrike_ranged")) {
            CRIT_DAMAGE_TRACKER.set(Float.valueOf(amount));
            IS_CRIT_FLAG.set(false);
            return amount;
        }
        if (config.isTridentEnabled() && source.method_5525().equals("trident") && (tridentMultiplierAttr = attacker.method_5996(KevsLibrary.TRIDENT_DAMAGE_MULTIPLIER)) != null) {
            amount = (float)((double)amount * tridentMultiplierAttr.method_6194());
        }
        boolean allowCrit = !source.method_48789(magicTag = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)class_2960.method_60655((String)"c", (String)"is_magic"))) && config.isCritEnabled();
        boolean isVanillaCrit = false;
        boolean isGroundedCrit = false;
        if (allowCrit) {
            class_1324 critChanceAttr;
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                isVanillaCrit = player.field_6017 > 0.0f && !player.method_24828();
            }
            double critChance = (critChanceAttr = attacker.method_5996(KevsLibrary.CRIT_CHANCE)) != null ? critChanceAttr.method_6194() : 0.0;
            isGroundedCrit = attacker.method_24828() && (double)attacker.method_59922().method_43057() < critChance;
        }
        boolean isCrit = isVanillaCrit || isGroundedCrit;
        float finalDamage = amount;
        if (isVanillaCrit) {
            finalDamage /= 1.5f;
        }
        if ((dmgMultAttr = attacker.method_5996(KevsLibrary.DAMAGE)) != null) {
            finalDamage *= (float)dmgMultAttr.method_6194();
        }
        if (isCrit) {
            float critMultiplier = attacker.method_5996(KevsLibrary.CRIT_DAMAGE) != null ? (float)attacker.method_45325(KevsLibrary.CRIT_DAMAGE) : 1.0f;
            finalDamage *= critMultiplier;
            if (critMultiplier > 1.0f && attacker instanceof class_1657) {
                class_1657 player2 = (class_1657)attacker;
                player2.method_37908().method_43128(null, player2.method_23317(), player2.method_23318(), player2.method_23321(), class_3417.field_15016, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
        CRIT_DAMAGE_TRACKER.set(Float.valueOf(finalDamage));
        IS_CRIT_FLAG.set(isCrit);
        return finalDamage;
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void onDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 p;
        boolean isCrit;
        class_1665 proj;
        class_1297 class_12972;
        SpellProjectile spell;
        class_1665 pp;
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        class_1309 target = (class_1309)this;
        KevsLibraryConfig config = KevsLibraryConfig.getInstance();
        if (OnHitEffectHandler.isInMultistrikeContext()) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        String name = source.method_5525();
        if (name.equals("multistrike") || name.equals("multistrike_ranged") || name.equals("icicle") || name.equals("frost_nova") || name.equals("chain_lightning") || name.equals("fire_tornado")) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        class_1297 class_12973 = source.method_5526();
        if (class_12973 instanceof class_1665 && (pp = (class_1665)class_12973).method_5752().contains("multistrike_arrow")) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        class_12973 = source.method_5529();
        if (class_12973 instanceof SpellProjectile && ((spell = (SpellProjectile)class_12973).method_5752().contains("real_spell_projectile") || spell.method_5752().contains("multistrike_spell"))) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        class_12973 = source.method_5529();
        if (!(class_12973 instanceof class_1309)) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        class_1309 attacker = (class_1309)class_12973;
        if (!target.method_37908().method_8608()) {
            boolean nearMultistrikeSpell;
            boolean bl = nearMultistrikeSpell = target.method_37908().method_8390(SpellProjectile.class, target.method_5829().method_1014(1.5), s -> s.method_5752().contains("multistrike_spell") && s.method_24921() == attacker).size() > 0;
            if (nearMultistrikeSpell) {
                CRIT_DAMAGE_TRACKER.remove();
                IS_CRIT_FLAG.remove();
                return;
            }
        }
        if ((class_12972 = source.method_5526()) instanceof class_1665 && !MultistrikeHandler.tryMarkProjectile((proj = (class_1665)class_12972).method_5667())) {
            CRIT_DAMAGE_TRACKER.remove();
            IS_CRIT_FLAG.remove();
            return;
        }
        float finalDamage = CRIT_DAMAGE_TRACKER.get() != null ? CRIT_DAMAGE_TRACKER.get().floatValue() : amount;
        boolean bl = isCrit = IS_CRIT_FLAG.get() != null && IS_CRIT_FLAG.get() != false;
        if (config.isThornsEnabled()) {
            ThornsHandler.tryReflectThorns(target, attacker, amount);
        }
        if (config.isCritEnabled()) {
            ((CritEvents.CritListener)CritEvents.CRIT.invoker()).onCrit(new CritEvents.Context(target, attacker, source, finalDamage, isCrit));
        }
        CRIT_DAMAGE_TRACKER.remove();
        IS_CRIT_FLAG.remove();
        class_1657 player = attacker instanceof class_1657 ? (p = (class_1657)attacker) : null;
        class_1799 weaponUsed = player != null ? player.method_6047().method_7972() : class_1799.field_8037;
        boolean stormHit = false;
        if (config.isProjectileStormEnabled()) {
            class_1665 pp2;
            class_1297 class_12974 = source.method_5526();
            if (class_12974 instanceof class_1665 && ProjectileStormHandler.isStormTag((class_1297)(pp2 = (class_1665)class_12974))) {
                stormHit = true;
            } else {
                SpellProjectile sp2;
                class_12974 = source.method_5526();
                if (class_12974 instanceof SpellProjectile && ProjectileStormHandler.isStormTag((class_1297)(sp2 = (SpellProjectile)class_12974))) {
                    stormHit = true;
                }
            }
        }
        if (!stormHit && config.isMultistrikeEnabled()) {
            double multistrikeChance;
            class_1324 multistrikeChanceAttr = attacker.method_5996(KevsLibrary.MULTISTRIKE_CHANCE);
            double d = multistrikeChance = multistrikeChanceAttr != null ? multistrikeChanceAttr.method_6194() : 0.0;
            if (attacker.method_59922().method_43058() <= multistrikeChance) {
                boolean hasNearbyRealSpellProjectile;
                boolean bl2 = hasNearbyRealSpellProjectile = target.method_37908().method_8390(SpellProjectile.class, target.method_5829().method_1014(3.0), proj2 -> {
                    boolean isOwned = proj2.method_24921() != null;
                    boolean hasSpell = proj2.getSpellEntry() != null;
                    boolean isLikelySpell = !proj2.method_5752().isEmpty();
                    boolean isNotMultistrike = !proj2.method_5752().contains("multistrike_spell");
                    return isOwned && isNotMultistrike && (hasSpell || isLikelySpell);
                }).size() > 0;
                if (!hasNearbyRealSpellProjectile) {
                    if (source.method_5526() != null) {
                        class_1324 dmgAttr0;
                        float dmgMul0;
                        float msBase = finalDamage;
                        if (source.method_5526() instanceof class_1685) {
                            float triMul;
                            class_1324 triAttr = attacker.method_5996(KevsLibrary.TRIDENT_DAMAGE_MULTIPLIER);
                            float f = triMul = triAttr != null ? (float)triAttr.method_6194() : 1.0f;
                            if (triMul != 0.0f) {
                                msBase = finalDamage / triMul;
                            }
                        }
                        float f = dmgMul0 = (dmgAttr0 = attacker.method_5996(KevsLibrary.DAMAGE)) != null ? (float)dmgAttr0.method_6194() : 1.0f;
                        if (dmgMul0 != 0.0f) {
                            msBase /= dmgMul0;
                        }
                        MultistrikeHandler.spawnHoveringProjectiles(attacker, target, msBase, source.method_5526(), weaponUsed);
                    } else {
                        MultistrikeHandler.triggerMultistrike(attacker, target, finalDamage, weaponUsed);
                    }
                }
            }
        }
        if (config.isFrostNovaEnabled()) {
            double frostChance;
            class_1324 frostNovaAttr = attacker.method_5996(KevsLibrary.FROST_NOVA_CHANCE);
            double d = frostChance = frostNovaAttr != null ? frostNovaAttr.method_6194() : 0.0;
            if (frostChance > 0.0 && attacker.method_59922().method_43058() < frostChance) {
                FrostNovaHandler.triggerFrostNova(attacker);
            }
        }
        if (config.isChainLightningEnabled()) {
            double roll;
            double lightningChance;
            class_1324 lightningChanceAttr = attacker.method_5996(KevsLibrary.CHAIN_LIGHTNING_CHANCE);
            double d = lightningChance = lightningChanceAttr != null ? lightningChanceAttr.method_6194() : 0.0;
            if (lightningChance > 0.0 && (roll = attacker.method_59922().method_43058()) < lightningChance) {
                ChainLightningHandler.spawnChainLightning(attacker, target);
            }
        }
        if (config.isFireTornadoEnabled()) {
            double fireTornadoChance;
            class_1324 fireTornadoAttr = attacker.method_5996(KevsLibrary.FIRE_TORNADO_CHANCE);
            double d = fireTornadoChance = fireTornadoAttr != null ? fireTornadoAttr.method_6194() : 0.0;
            if (fireTornadoChance > 0.0 && attacker.method_59922().method_43058() < fireTornadoChance) {
                FireTornadoHandler.spawnFireTornado(attacker, target);
            }
        }
        if (config.isSoulLinkEnabled()) {
            double soulLinkChance;
            class_1324 soulLinkAttr = attacker.method_5996(KevsLibrary.SOUL_LINK_CHANCE);
            double d = soulLinkChance = soulLinkAttr != null ? soulLinkAttr.method_6194() : 0.0;
            if (soulLinkChance > 0.0 && attacker.method_59922().method_43058() < soulLinkChance) {
                SoulLinkHandler.triggerSoulLink(attacker, target);
            }
            SoulLinkTracker.getGroup(target).ifPresent(linkData -> {
                if (!attacker.method_5667().equals(linkData.attacker().method_5667())) {
                    return;
                }
                SoulLinkHandler.handleLinkedDamage(linkData.attacker(), target, finalDamage, linkData.group(), linkData.soulPower());
            });
            SoulLinkTracker.getGroup(target).ifPresent(linkData -> {
                if (attacker.method_59922().method_43058() < soulLinkChance) {
                    SoulLinkHandler.tryExtendLink(attacker, target);
                }
            });
        }
        if (config.isArcaneRuptureEnabled()) {
            double arcaneChance;
            class_1324 arcaneChanceAttr = attacker.method_5996(KevsLibrary.ARCANE_RUPTURE_CHANCE);
            double d = arcaneChance = arcaneChanceAttr != null ? arcaneChanceAttr.method_6194() : 0.0;
            if (arcaneChance > 0.0 && attacker.method_59922().method_43058() < arcaneChance && !source.method_5525().equals("arcane_shard")) {
                ArcaneRuptureHandler.trigger(attacker, target);
            }
        }
        if (config.isCleaveEnabled() && !IN_CLEAVE_CONTEXT.get().booleanValue() && source.method_5526() == attacker) {
            IN_CLEAVE_CONTEXT.set(true);
            CleaveHandler.triggerCleave(attacker, finalDamage);
            IN_CLEAVE_CONTEXT.set(false);
        }
        if (config.isPiercingEnabled()) {
            if (PiercingHandler.isPiercingActive(attacker)) {
                PiercingHandler.consumePiercing(attacker);
                float pierceDamage = finalDamage * 0.75f;
                PiercingHandler.applyLineDamage(attacker, pierceDamage, 6.0f, 1.0f);
            } else {
                PiercingHandler.tryActivatePiercing(attacker);
            }
        }
    }
}

