/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1320;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.config.KevsLibraryConfig;

public class ConfiguredAttributeRegistry {
    private static final Map<String, class_6880<class_1320>> REGISTERED_ATTRIBUTES = new HashMap<String, class_6880<class_1320>>();

    public static class_6880<class_1320> registerAttribute(String name, class_1320 attribute) {
        KevsLibraryConfig config = KevsLibraryConfig.getInstance();
        if (!ConfiguredAttributeRegistry.shouldRegisterAttribute(name, config)) {
            KevsLibrary.LOGGER.info("Skipping attribute registration: {} (disabled in config)", (Object)name);
            return null;
        }
        class_6880.class_6883 entry = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)class_2960.method_60655((String)"kevslibrary", (String)name), (Object)attribute);
        REGISTERED_ATTRIBUTES.put(name, (class_6880<class_1320>)entry);
        KevsLibrary.LOGGER.debug("Registered attribute: {}", (Object)name);
        return entry;
    }

    private static boolean shouldRegisterAttribute(String attributeName, KevsLibraryConfig config) {
        if (!config.attributes.getOrDefault(attributeName, false).booleanValue()) {
            return false;
        }
        String parentSystem = ConfiguredAttributeRegistry.findParentSystem(attributeName);
        if (parentSystem == null) {
            return true;
        }
        if (!config.systems.getOrDefault(parentSystem, false).booleanValue()) {
            return false;
        }
        List<String> requiredAttributes = config.getSystemAttributes(parentSystem);
        if (requiredAttributes != null) {
            for (String siblingAttr : requiredAttributes) {
                if (config.attributes.getOrDefault(siblingAttr, false).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private static String findParentSystem(String attributeName) {
        KevsLibraryConfig config = KevsLibraryConfig.getInstance();
        for (String systemName : config.systems.keySet()) {
            List<String> systemAttrs = config.getSystemAttributes(systemName);
            if (systemAttrs == null || !systemAttrs.contains(attributeName)) continue;
            return systemName;
        }
        return null;
    }

    public static boolean isAttributeRegistered(String name) {
        return REGISTERED_ATTRIBUTES.containsKey(name);
    }

    public static class_6880<class_1320> getAttribute(String name) {
        return REGISTERED_ATTRIBUTES.get(name);
    }
}

