package archives.tater.leaderzombie.mixin;

import archives.tater.leaderzombie.LeaderZombie;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import me.pajic.zombieimprovements.util.ZombieExtension;
import net.minecraft.class_1299;
import net.minecraft.class_1322;
import net.minecraft.class_1322.class_1323;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5134;

@Mixin(class_1642.class)
public abstract class ZombieEntityMixin extends class_1588 {
    @Shadow
    @Final
    private static class_2960 LEADER_ZOMBIE_BONUS_MODIFIER_ID;

    protected ZombieEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/mob/ZombieEntity;setCanBreakDoors(Z)V"), method = "applyAttributeModifiers")
	private void init(CallbackInfo info) {
        method_5996(class_5134.field_23721).method_61163(new class_1322(LEADER_ZOMBIE_BONUS_MODIFIER_ID, this.field_5974.method_43058() * (double)1.5F + (double)1.0F, class_1323.field_6328));
	}

    @ModifyReturnValue(
            method = "getAmbientSound",
            at = @At("RETURN")
    )
    private class_3414 modifyAmbientSound(class_3414 original) {
        return ((ZombieExtension) this).zi$isLeader() ? LeaderZombie.AMBIENT : original;
    }

    @ModifyReturnValue(
            method = "getHurtSound",
            at = @At("RETURN")
    )
    private class_3414 modifyHurtSound(class_3414 original) {
        return ((ZombieExtension) this).zi$isLeader() ? LeaderZombie.HURT : original;
    }

    @ModifyReturnValue(
            method = "getDeathSound",
            at = @At("RETURN")
    )
    private class_3414 modifyDeathSound(class_3414 original) {
        return ((ZombieExtension) this).zi$isLeader() ? LeaderZombie.DEATH : original;
    }
}