/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.javautils;

import com.cleanroommc.javautils.JavaInstallImpl;
import com.cleanroommc.javautils.api.JavaInstall;
import com.cleanroommc.javautils.checker.JavaChecker;
import com.cleanroommc.platformutils.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

public final class JavaUtils {
    public static final String JAVA_EXECUTABLE = Platform.current().isWindows() ? "java.exe" : "java";

    public static File currentJarLocation() {
        return JavaUtils.jarLocationOf(JavaUtils.class);
    }

    public static File jarLocationOf(Class<?> clazz) {
        String url = null;
        try {
            url = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        if (url == null) {
            String suffix;
            URL resource = clazz.getResource(clazz.getSimpleName() + ".class");
            if (resource == null) {
                throw new RuntimeException("Could not find resource of " + clazz.getSimpleName() + ".class!");
            }
            String resourceString = resource.toString();
            if (!resourceString.endsWith(suffix = clazz.getCanonicalName().replace('.', '/') + ".class")) {
                throw new RuntimeException("Malformed URL for " + clazz.getSimpleName() + ".class: " + url);
            }
            url = resourceString.substring(0, resourceString.length() - suffix.length());
        }
        if (url.startsWith("jar:")) {
            url = url.substring(4, url.indexOf("!/"));
        }
        try {
            if (Platform.current().isWindows() && url.matches("file:[A-Za-z]:.*")) {
                url = "file:/" + url.substring(5);
            }
            return new File(new URL(url).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            if (url.startsWith("file:")) {
                url = url.substring(5);
                return new File(url);
            }
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    public static JavaInstall parseInstall(File location) throws IOException {
        return JavaUtils.parseInstall(location.getAbsolutePath());
    }

    public static JavaInstall parseInstall(String location) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        File workingJar = JavaUtils.jarLocationOf(JavaChecker.class);
        File workingDir = workingJar.getParentFile();
        processBuilder.directory(workingDir);
        File[] locations = JavaUtils.determine(location);
        File root = locations[0];
        File executable = locations[1];
        arguments.add(executable.getAbsolutePath());
        arguments.add("-cp");
        arguments.add(workingJar.getName());
        arguments.add(JavaChecker.class.getName());
        ArrayList<String> output = new ArrayList<String>();
        try {
            String inLine;
            Process process = processBuilder.start();
            BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((inLine = inReader.readLine()) != null) {
                output.add(inLine);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("Unable to parse install", e);
        }
        return JavaInstallImpl.of(root, executable, (String)output.get(0), (String)output.get(1));
    }

    private static File[] determine(String path) throws IOException {
        File file = new File(path);
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (file.isDirectory()) {
            if ("bin".equals(file.getName())) {
                file = file.getParentFile();
            } else {
                File bin = new File(file, "bin");
                if (!bin.isDirectory()) {
                    throw new IOException("Invalid location for a Java install. Searched in: " + path);
                }
            }
            File executable = new File(file, "bin/" + JAVA_EXECUTABLE);
            if (executable.isFile()) {
                return new File[]{file, executable};
            }
            throw new IOException("Invalid location for a Java install. Searched in: " + path);
        }
        throw new IOException("Path (" + path + ") does not exist in filesystem.");
    }

    private JavaUtils() {
    }
}

