/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.javautils.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class JavaVendor
implements Comparable<JavaVendor> {
    private static final List<JavaVendor> VENDORS = new ArrayList<JavaVendor>();
    public static final JavaVendor ADOPTIUM = JavaVendor.register("temurin|adoptium|eclipse foundation", "Eclipse Temurin");
    public static final JavaVendor ADOPTOPENJDK = JavaVendor.register("aoj|adoptopenjdk", "AdoptOpenJDK");
    public static final JavaVendor AMAZON = JavaVendor.register("amazon|corretto", "Amazon Corretto");
    public static final JavaVendor APPLE = JavaVendor.register("apple", "Apple");
    public static final JavaVendor AZUL = JavaVendor.register("azul|zulu", "Azul Zulu");
    public static final JavaVendor BELLSOFT = JavaVendor.register("bellsoft|liberica", "BellSoft Liberica");
    public static final JavaVendor GRAAL_VM = JavaVendor.register("graalvm|graal vm", "GraalVM Community");
    public static final JavaVendor HEWLETT_PACKARD = JavaVendor.register("hp|hewlett", "HP-UX");
    public static final JavaVendor IBM = JavaVendor.register("ibm|semeru|international business machines corporation", "IBM");
    public static final JavaVendor JETBRAINS = JavaVendor.register("jbr|jetbrains", "JetBrains");
    public static final JavaVendor MICROSOFT = JavaVendor.register("microsoft", "Microsoft");
    public static final JavaVendor ORACLE = JavaVendor.register("oracle", "Oracle");
    public static final JavaVendor SAP = JavaVendor.register("sap", "SAP SapMachine");
    public static final JavaVendor TENCENT = JavaVendor.register("tencent|kona", "Tencent");
    public static final JavaVendor UNKNOWN = JavaVendor.register("unknown", "Unknown Vendor");
    private final Pattern pattern;
    private final String name;

    public static List<JavaVendor> all() {
        return Collections.unmodifiableList(VENDORS);
    }

    public static JavaVendor register(String regex, String name) {
        return new JavaVendor(regex, name);
    }

    public static JavaVendor find(String rawVendor) {
        if (rawVendor == null || rawVendor.isEmpty()) {
            return UNKNOWN;
        }
        for (JavaVendor vendor : VENDORS) {
            if (vendor.name.equalsIgnoreCase(rawVendor)) {
                return vendor;
            }
            if (!vendor.pattern.matcher(rawVendor).find()) continue;
            return vendor;
        }
        return UNKNOWN;
    }

    public JavaVendor(String regex, String name) {
        this.pattern = Pattern.compile(regex, 2);
        this.name = name;
        VENDORS.add(this);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(JavaVendor javaVendor) {
        return this.name.compareTo(javaVendor.name);
    }
}

