/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.javautils.locators;

import com.cleanroommc.javautils.JavaUtils;
import com.cleanroommc.javautils.api.JavaInstall;
import com.cleanroommc.javautils.spi.JavaLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaLocator
implements JavaLocator {
    protected static final Logger LOGGER = LoggerFactory.getLogger("JavaLocator");
    private boolean initialized;
    private Set<JavaInstall> javaInstalls;

    protected static String env(String key) {
        return System.getenv(key);
    }

    protected static String property(String key) {
        return System.getProperty(key);
    }

    protected static String userHome() {
        return AbstractJavaLocator.property("user.home");
    }

    protected static String userHome(String directory) {
        return AbstractJavaLocator.userHome() + "/" + directory;
    }

    protected static void logParseError(File file, IOException e) {
        AbstractJavaLocator.logParseError(file.getAbsolutePath(), e);
    }

    protected static void logParseError(String path, IOException e) {
        LOGGER.error("Unable to parse {} as a JavaInstall", (Object)path, (Object)e);
    }

    protected static void parseOrLog(List<JavaInstall> installs, File file) {
        try {
            installs.add(JavaUtils.parseInstall(file));
        }
        catch (IOException e) {
            AbstractJavaLocator.logParseError(file, e);
        }
    }

    protected static void parseOrLog(List<JavaInstall> installs, String file) {
        try {
            installs.add(JavaUtils.parseInstall(file));
        }
        catch (IOException e) {
            AbstractJavaLocator.logParseError(file, e);
        }
    }

    protected static JavaInstall parseOrLog(File file) {
        try {
            return JavaUtils.parseInstall(file);
        }
        catch (IOException e) {
            AbstractJavaLocator.logParseError(file, e);
            return null;
        }
    }

    protected static JavaInstall parseOrLog(String file) {
        try {
            return JavaUtils.parseInstall(file);
        }
        catch (IOException e) {
            AbstractJavaLocator.logParseError(file, e);
            return null;
        }
    }

    protected static void deepScanForInstalls(File directory, List<JavaInstall> installs) {
        if (!directory.exists()) {
            return;
        }
        AbstractJavaLocator.walk(directory, file -> {
            File location = new File((File)file, "bin/" + JavaUtils.JAVA_EXECUTABLE);
            if (location.isFile()) {
                AbstractJavaLocator.parseOrLog(installs, location);
                return true;
            }
            return false;
        });
    }

    private static void walk(File directory, Function<File, Boolean> run) {
        File[] subDirectories = directory.listFiles(File::isDirectory);
        if (subDirectories != null) {
            for (File subDirectory : subDirectories) {
                if (run.apply(subDirectory).booleanValue()) continue;
                AbstractJavaLocator.walk(subDirectory, run);
            }
        }
    }

    protected abstract List<JavaInstall> initialize();

    @Override
    public Set<JavaInstall> get(Predicate<JavaInstall> predicate) {
        this.init();
        return this.javaInstalls.stream().filter(predicate).collect(Collectors.toSet());
    }

    @Override
    public Set<JavaInstall> all() {
        this.init();
        return Collections.unmodifiableSet(this.javaInstalls);
    }

    private void init() {
        if (!this.initialized) {
            this.initialized = true;
            List<JavaInstall> resolvedJavaInstalls = this.initialize();
            this.javaInstalls = resolvedJavaInstalls.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }
}

